package org.gcube.informationsystem.icproxy.swagger;


import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiKeyAuthDefinition.ApiKeyLocation;
import io.swagger.annotations.Contact;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.annotations.Info;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;


@SwaggerDefinition(
		info = @Info(
				description = "This is the official documentation of Infrastructure Information System (Registry) Web Service.",
				version = "V 1.2",
				title = "Registry RESTful Service",
				contact = @Contact(
						name = "Lucio Lelii", 
						email ="lucio.lelii@isti.cnr.it"
						),
						extensions = {
					@Extension(name = "development-host", properties = {
							@ExtensionProperty(name = "url", value = "https://node10-d-d4s.d4science.org/"),
					})
				}
				),
				host="registry.d4science.org",
				basePath="ic-proxy/gcube/service/",
				securityDefinition=@SecurityDefinition(
						apiKeyAuthDefinitions={
								@ApiKeyAuthDefinition(key=Bootstrap.GCUBE_TOKEN_IN_QUERY_DEF, description="A token bound to a user (or app identifier) and a context", in=ApiKeyLocation.HEADER, name="gcube-token"),
								@ApiKeyAuthDefinition(key=Bootstrap.GCUBE_TOKEN_IN_HEADER_DEF, description="A token bound to a user (or app identifier) and a context", in=ApiKeyLocation.QUERY, name="gcube-token")
						}),
						schemes = {SwaggerDefinition.Scheme.HTTP, SwaggerDefinition.Scheme.HTTPS}
		)
public interface ICProxyConfig {

}
