/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="GenericResource")
@Api(value="GenericResource", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class GenericResourceResource {
    private static final Logger log = LoggerFactory.getLogger(GenericResourceResource.class);

    @GET
    @Path(value="/{secondaryType}/{name}")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve a Generic Resource by specifying the secondary type and name within the path.", response=String.class, notes="Retrieve a Generic Resource by specifying the secondary type and name within the path. For example: /icproxy/gcube/service/GenericResource/GenericResource/ScenarioCollectionInfo retrieves the Generic Resource having secondary type GenericResource and name ScenarioCollectionInfo.", nickname="get-generic-resource")
    public List<GenericResource> retrieveByTypeAndName(@NotNull @PathParam(value="secondaryType") String secondaryType, @NotNull @PathParam(value="name") String resourceName) {
        String scope = ScopeProvider.instance.get();
        log.info("genericResource called with secondaryType {} and name {} in scope {}", new Object[]{secondaryType, resourceName, scope});
        SimpleQuery query = this.createSecondaryTypeQuery(secondaryType).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", resourceName));
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/{secondaryType}")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve a list of Generic Resources by specifying the secondary type within the path.", response=String.class, notes="Retrieve a list of Generic Resources by specifying the secondary type within the path. For example: /ic-proxy/gcube/service/GenericResource/GenericResource/ retrieves the Generic Resources having secondary type GenericResource.", nickname="get-generic-resources-by-secondary-type")
    public List<GenericResource> retrieveByType(@NotNull @PathParam(value="secondaryType") String secondaryType) {
        String scope = ScopeProvider.instance.get();
        log.info("genericResource called with secondaryType {} in scope {}", (Object)secondaryType, (Object)scope);
        SimpleQuery query = this.createSecondaryTypeQuery(secondaryType);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    SimpleQuery createSecondaryTypeQuery(String secondaryTpe) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition(String.format("$resource/Profile/SecondaryType/text() eq '%s'", secondaryTpe));
        return query;
    }
}

