/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="HostingNode")
@Api(value="HostingNode", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class HostingNodeResource {
    private static final Logger log = LoggerFactory.getLogger(HostingNodeResource.class);

    @GET
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve the whole list of hosting nodes.", response=String.class, notes="Retrieve the whole list of hosting nodes.", nickname="get-hosting-nodes")
    public List<HostingNode> retrieve() {
        XQuery query = ICFactory.queryFor(HostingNode.class);
        query.addCondition("$resource/Profile/GHNDescription/Status/text() eq \"certified\"");
        DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/{id}/GCoreEndpoints")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve the hosting node by id, for GCoreEndpoints.", response=String.class, notes="Retrieve the hosting node by id, for GCoreEndpoints.", nickname="get-hosting-node-by-id")
    public List<GCoreEndpoint> retrieveGcoreEnpoints(@NotNull @PathParam(value="id") String id) {
        log.info("hostingnode called for GCoreEndpoint running on HostingNode with id {}", (Object)id);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition(String.format("$resource/Profile/GHN/@UniqueID/string() eq '%s'", id));
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/CustomQuery")
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve an hosting node by using a custom query.", response=String.class, notes="Retrieve an hosting node by using a custom query, defined into the query parameter 'result'", nickname="get-hosting-node-by-query")
    public String retrieve(@NotNull @QueryParam(value="result") String resultXPath) {
        log.info("hostingnode called (with result {}) ", (Object)resultXPath);
        XQuery query = ICFactory.queryFor(HostingNode.class);
        if (resultXPath != null && !resultXPath.isEmpty()) {
            if (resultXPath.startsWith("/")) {
                query.setResult("$resource" + resultXPath);
            } else {
                query.setResult("$resource/" + resultXPath);
            }
        }
        query.addCondition("$resource/Profile/GHNDescription/Status/text() eq \"certified\"");
        DiscoveryClient client = ICFactory.client();
        List endpoints = client.submit((Query)query);
        StringBuilder builder = new StringBuilder("<Results>");
        for (String single : endpoints) {
            builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
        }
        builder.append("</Results>");
        log.debug("retrieved resources are " + endpoints.size());
        return builder.toString();
    }
}

