package org.gcube.informationsystem.icproxy.resources;

import static org.gcube.resources.discovery.icclient.ICFactory.client;
import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.validation.constraints.NotNull;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import lombok.extern.slf4j.Slf4j;

//import org.gcube.common.authorization.library.provider.AccessTokenProvider;
//import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.resources.gcore.*;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
//import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.common.encryption.StringEncrypter;

@Slf4j
@Path("ServiceEndpoint")
public class ServiceEndpointResource {
	
	@GET
	@Path("/{category}")
	@Produces(MediaType.APPLICATION_XML)
	public List<ServiceEndpoint> retrieve(@NotNull @PathParam("category") String resourceCategory) {
		log.info("ServiceEndpoint called with category {} in context {}",resourceCategory, ScopeProvider.instance.get());
		
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		List<ServiceEndpoint> endpoints = client.submit(getQuery(resourceCategory));
		log.debug("retrieved resources are "+endpoints.size());
		return endpoints; 
	}

//	@GET
//	@Path("/{category}/{name}")
//	@Produces(MediaType.APPLICATION_XML)
//	public List<ServiceEndpoint> retrieve(@NotNull @PathParam("name") String resourceName,
//			@NotNull @PathParam("category") String resourceCategory) {
//		log.info("ServiceEndpoint called with category {} and name {} in scope {}",resourceCategory, resourceName, ScopeProvider.instance.get());
//
//		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
//
//		List<ServiceEndpoint> endpoints = client.submit(getQuery(resourceName, resourceCategory));
//		log.debug("retrieved resources are "+endpoints.size());
//		return endpoints;
//	}

	@GET
	@Path("/{category}/{name}")
	@Produces(MediaType.APPLICATION_XML)
	public List<ServiceEndpoint> retrieve(@NotNull @PathParam("name") String resourceName,
										  @NotNull @PathParam("category") String resourceCategory, @QueryParam("decrypt") boolean isDecrypt) {
		log.info("ServiceEndpoint called with category {} and name {} in scope {}",resourceCategory, resourceName, ScopeProvider.instance.get());
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> endpoints = client.submit(getQuery(resourceName, resourceCategory));
		if(Objects.nonNull(endpoints)) {
			log.debug("retrieved resources are "+endpoints.size());
			if (isDecrypt) {
	//			if (isRoleEnabled()){
					List<ServiceEndpoint> ses = new ArrayList<>(endpoints.size());
					for (ServiceEndpoint resource : endpoints) {
						ses.add(decryptResource(resource));
					}
					return ses;
	//			}else{
	//				log.info("user not enabled to see the resource free to air, sorry");
	//			}
			}
		}
		return endpoints;
	}

//	private boolean isRoleEnabled(){
//		String at=AccessTokenProvider.instance.get();
//		try{
//			if (ModelUtils.getAccessTokenFrom(at).getRealmAccess().getRoles().contains("service-endpoint-key" )) {
//				log.info("The client is authorized to see the resource as 'free-to-air'");
//				return true;
//			}
//		}catch (Exception e){
//			log.error("token not retrieved properly: "+e.getMessage());
//			e.printStackTrace();
//		}
//		log.info("user not authorized, sorry");
//		return false;
//	}

//	@GET
//	@Path("/{category}/{name}/{ap}")
//	@Produces(MediaType.TEXT_XML)
//	public String retrieve(@NotNull @PathParam("name") String resourceName,
//										  @NotNull @PathParam("category") String resourceCategory,
//										  @NotNull @PathParam("ap") String accessPoint) {
//		log.info("ServiceEndpoint called with category {}, name {} and accessPoint {} in scope {}",resourceCategory, resourceName, accessPoint, ScopeProvider.instance.get());
//		XQuery query=queryFor(ServiceEndpoint.class);
//		query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'",resourceName));
//		query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'",resourceCategory));
//		query.setResult("$resource/Profile/AccessPoint/Interface/Endpoint[@EntryName='"+accessPoint+"']/text()");
//		DiscoveryClient<String> client = client();
//		List<String> accessList= client.submit(query);
//		if (Objects.nonNull(accessList))
//			return accessList.get(0).toString();
//		else
//			log.warn("endpoint not found with following coordinates: {} {} and accesspoint: {}", resourceCategory, resourceName,accessPoint);
//		return null;
//	}

	@GET
	@Path("/{category}/{name}/Result/{result:([^$\\?]+)}")
	@Produces(MediaType.TEXT_XML)
	public String retrieveCustom(@NotNull @PathParam("name") String resourceName, 
			@NotNull @PathParam("category") String resourceCategory, @NotNull @PathParam("result") String resultXPath) {
		log.info("ServiceEndpoint called with category {} and name {} and result {} in scope {}"
				,resourceCategory, resourceName, resultXPath, ScopeProvider.instance.get());
		
		SimpleQuery query = getQuery(resourceName, resourceCategory);
				
		if (resultXPath.startsWith("/"))
			query.setResult("$resource"+resultXPath);
		else
			query.setResult("$resource/"+resultXPath);
		
		DiscoveryClient<String> client = client();
		List<String> endpoints = client.submit(query);
		StringBuilder builder = new StringBuilder("<Results>");
		for (String single: endpoints)
			builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
		
		builder.append("</Results>");
		
		log.debug("retrieved resources are "+endpoints.size());
		return builder.toString(); 
	}

	private SimpleQuery getQuery(String resourceName, String resourceCategory){
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'",resourceName));
		query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'",resourceCategory));
		return query;
	}
	
	private SimpleQuery getQuery(String resourceCategory){
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'",resourceCategory));
		return query;
	}

	private ServiceEndpoint decryptResource(ServiceEndpoint resource) {
		Group<ServiceEndpoint.AccessPoint> aps=resource.profile().accessPoints();
		for (ServiceEndpoint.AccessPoint ap : aps){
			String decrypted =decryptString(ap.password());
			String user= ap.username();

			ap.credentials(decrypted, user);
		}
		return resource;
	}

	public static String decryptString(String toDecrypt){
		try{
			return StringEncrypter.getEncrypter().decrypt(toDecrypt);
		}catch(Exception e) {
			throw new RuntimeException("Unable to decrypt : "+toDecrypt,e);
		}
	}

}
