/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.UUID;
import org.gcube.informationsystem.impl.utils.ISMapper;

public abstract class Utility {
    public static String getClassFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("@class").asText();
    }

    public static String getClassFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ISMapper.getObjectMapper().readTree(json);
        return Utility.getClassFromJsonNode(jsonNode);
    }

    public static String getUUIDStringFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("header").get("@class").asText();
    }

    public static UUID getUUIDFromJsonNode(JsonNode jsonNode) {
        String uuidString = Utility.getUUIDStringFromJsonNode(jsonNode);
        return UUID.fromString(uuidString);
    }

    public static String getUUIDStringFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ISMapper.getObjectMapper().readTree(json);
        return Utility.getUUIDStringFromJsonNode(jsonNode);
    }

    public static UUID getUUIDFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ISMapper.getObjectMapper().readTree(json);
        return Utility.getUUIDFromJsonNode(jsonNode);
    }
}

