/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.contexts;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtility {
    private static Logger logger = LoggerFactory.getLogger(ContextUtility.class);

    public static Set<UUID> getContextUUIDSet(String jsonArray) throws IOException {
        ObjectMapper mapper = ElementMapper.getObjectMapper();
        CollectionType type = mapper.getTypeFactory().constructCollectionType(HashSet.class, UUID.class);
        return (Set)mapper.readValue(jsonArray, (JavaType)type);
    }

    public static Set<String> getContextFullNameSet(String jsonArray) throws Exception {
        Set<UUID> uuids = ContextUtility.getContextUUIDSet(jsonArray);
        return ContextUtility.getContextFullNameSet(uuids);
    }

    public static Set<UUID> getContextUUIDSet(Collection<String> uuidStrings) throws Exception {
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (String uuidString : uuidStrings) {
            UUID uuid = UUID.fromString(uuidString);
            uuids.add(uuid);
        }
        return uuids;
    }

    public static Set<String> getContextFullNameSet(Collection<UUID> uuids) throws Exception {
        ContextCache contextCache = ContextCache.getInstance();
        HashSet<String> contextFullNames = new HashSet<String>();
        try {
            Map<UUID, String> uuidToContextFullNameAssociation = contextCache.getUUIDToContextFullNameAssociation();
            if (!uuidToContextFullNameAssociation.keySet().containsAll(uuids)) {
                logger.debug("{} does not contain all the contexts identified by the following UUID list. Trying to invalidate the cache", (Object)ContextCache.class.getSimpleName(), uuids);
                contextCache.cleanCache();
                uuidToContextFullNameAssociation = contextCache.getUUIDToContextFullNameAssociation();
            }
            for (UUID uuid : uuids) {
                String fullName = uuidToContextFullNameAssociation.get(uuid);
                if (fullName == null) {
                    throw new Exception("Unable to get the full name of context with UUID " + uuid.toString());
                }
                contextFullNames.add(fullName);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to convert Set<UUID> to Set<String> containing Context Full Name. Be sure the cache has been configured to retrieve the context list or provide a valid UUID list", e);
        }
        return contextFullNames;
    }
}

