package org.gcube.informationsystem.resourceregistry.api.exceptions.entities;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.CreationException;

/**
 * The Class EntityCreationException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class EntityCreationException extends CreationException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -4445129394716597536L;
	
	/**
	 * Instantiates a new entity creation exception.
	 *
	 * @param message the message
	 */
	public EntityCreationException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new entity creation exception.
	 *
	 * @param cause the cause
	 */
	public EntityCreationException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new entity creation exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public EntityCreationException(String message, Throwable cause) {
		super(message, cause);
	}
}
