package org.gcube.informationsystem.resourceregistry.api.exceptions.types;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;

/**
 * The Class SchemaAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class SchemaAlreadyPresentException extends AlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -6141449434537456516L;

	/**
	 * Instantiates a new schema already present exception.
	 *
	 * @param message the message
	 */
	public SchemaAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new schema already present exception.
	 *
	 * @param cause the cause
	 */
	public SchemaAlreadyPresentException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new schema already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public SchemaAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}

}
