package org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.EntityAlreadyPresentException;

/**
 * The Class ResourceAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceAlreadyPresentException extends EntityAlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 4412436343971879115L;

	/**
	 * Instantiates a new resource already present exception.
	 *
	 * @param message the message
	 */
	public ResourceAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new resource already present exception.
	 *
	 * @param cause the cause
	 */
	public ResourceAlreadyPresentException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new resource already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ResourceAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}
}
