package org.gcube.informationsystem.resourceregistry.api.exceptions.relations;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;

/**
 * The Class RelationNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class RelationNotFoundException extends NotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -5236597489824997797L;

	/**
	 * Instantiates a new relation not found exception.
	 *
	 * @param message the message
	 */
	public RelationNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new relation not found exception.
	 *
	 * @param cause the cause
	 */
	public RelationNotFoundException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new relation not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public RelationNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
