/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client.proxy;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.GCubeEndpoint;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InvalidQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClient {
    private static Logger logger = LoggerFactory.getLogger(ResourceRegistryClient.class);
    private final AsyncProxyDelegate<GCubeEndpoint> delegate;

    public ResourceRegistryClient(ProxyDelegate<GCubeEndpoint> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    protected HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (includeTokenInHeader) {
            connection.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
        }
        connection.setRequestMethod(method);
        return connection;
    }

    protected void appendQueryParameter(StringBuilder builder, String name, String value) throws UnsupportedEncodingException {
        builder.append(name).append("=");
        String encodedValue = URLEncoder.encode(value, "UTF-8");
        builder.append(encodedValue).append("&");
    }

    public String query(final String query, final String fetchPlan) throws InvalidQueryException {
        Call<GCubeEndpoint, String> call = new Call<GCubeEndpoint, String>(){

            public String call(GCubeEndpoint endpoint) throws Exception {
                StringBuilder callUrl = new StringBuilder(endpoint.getAddress());
                callUrl.append("/").append("access").append("/");
                ResourceRegistryClient.this.appendQueryParameter(callUrl, "query", query);
                if (fetchPlan != null) {
                    ResourceRegistryClient.this.appendQueryParameter(callUrl, "fetchPlan", fetchPlan);
                }
                URL url = new URL(callUrl.toString());
                HttpURLConnection connection = ResourceRegistryClient.this.makeRequest(url, "GET", false);
                connection.setDoOutput(true);
                connection.setDoInput(false);
                connection.setRequestProperty("Content-type", "text/plain");
                logger.debug("Response code for {} is {} : {}", new Object[]{callUrl.toString(), connection.getResponseCode(), connection.getResponseMessage()});
                if (connection.getResponseCode() != 200) {
                    throw new Exception("Error Querying Resource Registry Service");
                }
                StringBuilder result = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                }
                return result.toString();
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

