/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client.proxy;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.ws.EndpointReference;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ER;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.client.proxy.Direction;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClientCall;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryQuery;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    private final AsyncProxyDelegate<EndpointReference> delegate;
    public static final String PATH_SEPARATOR = "/";

    public ResourceRegistryClientImpl(ProxyDelegate<EndpointReference> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    @Override
    public <ERType extends ER> ERType getInstance(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, null);
            ResourceRegistryClientCall<ERType> call = new ResourceRegistryClientCall<ERType>(clazz, httpCall);
            ER erType = (ER)this.delegate.make(call);
            logger.info("Got {} with UUID {} is {}", new Object[]{type, uuid, erType});
            return (ERType)erType;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while getting {} with UUID {}", new Object[]{type, uuid, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while getting {} with UUID {}", new Object[]{type, uuid, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List<? extends Entity> getInstances(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpCall);
            String ret = (String)this.delegate.make(call);
            logger.info("Got instances of {} are {}", (Object)type, (Object)ret);
            return ISMapper.unmarshalList(Entity.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while getting {} instances", (Object)type, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while getting {} instances", (Object)type, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List<Resource> getInstancesFromEntity(String relationType, Boolean polymorphic, UUID reference, Direction direction) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} from/to {}", (Object)relationType, (Object)reference.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(relationType);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            parameters.put("reference", reference.toString());
            parameters.put("direction", direction.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpCall);
            String ret = (String)this.delegate.make(call);
            logger.info("Got instances of {} from/to {} are {}", new Object[]{relationType, reference.toString(), ret});
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while getting instances of {} from/to {}", (Object)relationType, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while getting instances of {} from/to {}", (Object)relationType, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> getSchema(Class<ISM> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        String type = clazz.getSimpleName();
        try {
            logger.info("Going to get {} schema", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            ResourceRegistryClientCall<String> call = new ResourceRegistryClientCall<String>(String.class, httpCall);
            String schema = (String)this.delegate.make(call);
            logger.info("Got schema for {} is {}", (Object)type, (Object)schema);
            return TypeBinder.deserializeTypeDefinitions((String)schema);
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while getting {}schema for {}", new Object[]{polymorphic != false ? "polymorphic " : "", type, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while getting {}schema for {}", new Object[]{polymorphic != false ? "polymorphic " : "", type, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException {
        ResourceRegistryQuery rrq = new ResourceRegistryQuery((ProxyDelegate<EndpointReference>)this.delegate);
        return rrq.query(query, limit, fetchPlan);
    }
}

