/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ER;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryClientImpl(String address) {
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryClient.class.getSimpleName());
        }
        return this.httpCall;
    }

    @Override
    public <ERType extends ER> boolean exists(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getType(clazz);
        return this.exists(type, uuid);
    }

    @Override
    public boolean exists(String type, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to check if {} with UUID {} exists", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.HEAD);
            logger.debug("{} with UUID {} exists", (Object)type, (Object)uuid);
            return true;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERType extends ER> ERType getInstance(Class<ERType> clazz, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getType(clazz);
        String ret = this.getInstance(type, uuid);
        try {
            return (ERType)((ER)ISMapper.unmarshal(clazz, (String)ret));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstance(String type, UUID uuid) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got {} with UUID {} is {}", new Object[]{type, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERType extends ER, R extends Resource> List<R> getInstances(Class<ERType> clazz, Boolean polymorphic) throws ResourceRegistryException {
        String type = Utility.getType(clazz);
        String ret = this.getInstances(type, polymorphic);
        try {
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstances(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got instances of {} are {}", (Object)type, (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERType extends ER, E extends Entity, R extends Resource> List<R> getInstancesFromEntity(Class<ERType> clazz, Boolean polymorphic, E reference, Direction direction) throws ResourceRegistryException {
        return this.getInstancesFromEntity(clazz, polymorphic, reference.getHeader().getUUID(), direction);
    }

    @Override
    public <ERType extends ER, R extends Resource> List<R> getInstancesFromEntity(Class<ERType> clazz, Boolean polymorphic, UUID reference, Direction direction) throws ResourceRegistryException {
        String type = Utility.getType(clazz);
        String ret = this.getInstancesFromEntity(type, polymorphic, reference, direction);
        try {
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstancesFromEntity(String type, Boolean polymorphic, UUID reference, Direction direction) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} from/to {}", (Object)type, (Object)reference.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            parameters.put("reference", reference.toString());
            parameters.put("direction", direction.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got instances of {} from/to {} are {}", new Object[]{type, reference.toString(), ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource, F extends Facet, C extends ConsistsOf<?, ?>> List<R> getFilteredResources(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, boolean polymorphic, Map<String, Object> map) throws ResourceRegistryException {
        String resourceType = Utility.getType(resourceClass);
        String consistsOfType = Utility.getType(consistsOfClass);
        String facetType = Utility.getType(facetClass);
        String ret = this.getFilteredResources(resourceType, consistsOfType, facetType, polymorphic, map);
        try {
            return ISMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFilteredResources(String resourceType, String consistsOfType, String facetType, boolean polymorphic, Map<String, Object> map) throws ResourceRegistryException {
        try {
            logger.info("Going to get Filtered Resources ({}) linked by a ConsistsOf Relation ({}) to a Facet ({}) having {}", new Object[]{resourceType, consistsOfType, facetType, map});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resourceInstances");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resourceType);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(consistsOfType);
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facetType);
            stringWriter.append(PATH_SEPARATOR);
            HashMap<String, Object> parameters = new HashMap<String, Object>(map);
            parameters.put("polymorphic", polymorphic);
            HTTPCall httpCall = this.getHTTPCall();
            String json = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.info("Filtered Resources ({}) linked by a ConsistsOf Relation ({}) to a Facet ({}) having {} are : {}", new Object[]{resourceType, consistsOfType, facetType, map, json});
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException, ResourceRegistryException {
        try {
            logger.info("Going to query. {}", (Object)query);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("query", query);
            if (limit <= 0) {
                limit = -1;
            }
            parameters.put("limit", Integer.toString(limit));
            if (fetchPlan != null) {
                parameters.put("fetchPlan", fetchPlan);
            }
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Query result is {}", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context getContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} with UUID {}", (Object)"Context", (Object)uuid.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            Context context = (Context)httpCall.call(Context.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got Context is {}", (Object)ISMapper.marshal((ISManageable)context));
            return context;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> getAllContext() throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to read all {}s", (Object)"Context");
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("all");
            HTTPCall httpCall = this.getHTTPCall();
            String ret = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got Contexts are {}", (Object)ret);
            return ISMapper.unmarshalList(Context.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> getSchema(Class<ISM> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        String type = Utility.getType(clazz);
        try {
            logger.info("Going to get {} schema", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String json = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got schema for {} is {}", (Object)type, (Object)json);
            return TypeBinder.deserializeTypeDefinitions((String)json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

