/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientImpl;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientFactory.class);
    protected static Map<String, ResourceRegistryClient> clients = new HashMap<String, ResourceRegistryClient>();
    private static String FORCED_URL = null;
    private static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    private static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    private static String containsFormat = "$entry/@EntryName eq '%1s'";
    private static String serviceEndpointCategoryFormat = "$resource/Profile/Category/text() eq '%1s'";
    private static String serviceEndpointNameFormat = "$resource/Profile/Name/text() eq '%1s'";
    private static String serviceEndpointstatusFormat = "$resource/Profile/RunTime/Status/text() eq 'READY'";

    protected static void forceToURL(String url) {
        FORCED_URL = url;
    }

    private static SimpleQuery queryForService() {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, "InformationSystem")).addCondition(String.format(nameFormat, "resource-registry")).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, "org.gcube.informationsystem.resourceregistry.ResourceInitializer")).setResult("$entry/text()");
    }

    private static SimpleQuery queryForProxy() {
        return ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format(serviceEndpointCategoryFormat, "InformationSystem")).addCondition(String.format(serviceEndpointNameFormat, "resource-registry")).addCondition(String.format(serviceEndpointstatusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/Interface/Endpoint").addCondition(String.format(containsFormat, "org.gcube.informationsystem.resourceregistry.ResourceInitializer")).setResult("$entry/text()");
    }

    protected static List<String> getAddresses() {
        List<String> addresses = new ArrayList();
        try {
            SimpleQuery proxyQuery = ResourceRegistryClientFactory.queryForProxy();
            addresses = ICFactory.client().submit((Query)proxyQuery);
            if (addresses == null || addresses.isEmpty()) {
                throw new Exception("No ResourceRegistry Proxy Found");
            }
        }
        catch (Exception e) {
            logger.debug("{}. Looking for RunningInstance.", (Object)e.getMessage());
            SimpleQuery serviceQuery = ResourceRegistryClientFactory.queryForService();
            addresses = ICFactory.client().submit((Query)serviceQuery);
        }
        return addresses;
    }

    public static ResourceRegistryClient create() {
        if (FORCED_URL != null) {
            return new ResourceRegistryClientImpl(FORCED_URL);
        }
        String key = null;
        if (SecurityTokenProvider.instance.get() == null) {
            if (ScopeProvider.instance.get() == null) {
                throw new RuntimeException("Null Token and Scope. Please set your token first.");
            }
            key = ScopeProvider.instance.get();
        } else {
            key = SecurityTokenProvider.instance.get();
        }
        ResourceRegistryClient client = clients.get(key);
        if (client == null) {
            List<String> addresses = ResourceRegistryClientFactory.getAddresses();
            if (addresses == null || addresses.isEmpty()) {
                String error = String.format("No %s:%s found in the current context", "InformationSystem", "resource-registry");
                throw new RuntimeException(error);
            }
            Random random = new Random();
            int index = random.nextInt(addresses.size());
            client = new ResourceRegistryClientImpl(addresses.get(index));
        }
        return client;
    }
}

