/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.UUID;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientImpl
implements ResourceRegistryContextClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryContextClientImpl(String address) {
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryContextClient.class.getSimpleName());
        }
        return this.httpCall;
    }

    @Override
    public Context create(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String contextString = ISMapper.marshal((ISManageable)context);
            String res = this.create(contextString);
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)context);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, context);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context read(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.read(context.getHeader().getUUID());
    }

    @Override
    public Context read(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String res = this.read(uuid.toString());
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context");
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid);
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got {} is {}", (Object)"Context", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context update(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String contextString = ISMapper.marshal((ISManageable)context);
            String res = this.update(contextString);
            return (Context)ISMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to update: {}", (Object)context);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, context);
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(context.getHeader().getUUID());
    }

    @Override
    public boolean delete(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(uuid.toString());
    }

    @Override
    public boolean delete(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)"Context", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid);
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Context", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> all() throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context");
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("context");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("all");
            HTTPCall httpCall = this.getHTTPCall();
            String all = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET);
            logger.debug("Got contexts are {}", (Object)"Context", (Object)all);
            return ISMapper.unmarshalList(Context.class, (String)all);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

