package org.gcube.informationsystem.resourceregistry.contexts;

import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resourceregistry.api.Constants;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceRegistryContextClientFactory {
	
	private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientFactory.class);

	public static String getCurrentContextFullName() {
		String token = SecurityTokenProvider.instance.get();
		AuthorizationEntry authorizationEntry = null;
		try {
			authorizationEntry = org.gcube.common.authorization.client.Constants.authorizationService().get(token);
		} catch(Exception e) {
			return ScopeProvider.instance.get();
		}
		return authorizationEntry.getContext();
	}
	
	private static String FORCED_URL = null;
	
	protected static void forceToURL(String url){
		FORCED_URL = url;
	}
	
	public static ResourceRegistryContextClient create() {
		String address = null;
		
		if(FORCED_URL!=null){
			address = FORCED_URL;
		}else {
			address = String.format("%s/%s", ServiceInstance.getServiceURL(),Constants.SERVICE_NAME);
		}
		
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistryContextClientImpl(address);
	}
	
}
