/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryPublisherImpl(String address) {
        this.address = address;
    }

    protected HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryPublisher.class.getSimpleName());
        }
        return this.httpCall;
    }

    private static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    @Override
    public <F extends Facet> F createFacet(Class<F> facetClass, F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facetClass.getSimpleName());
            String body = ISMapper.marshal(facet);
            HTTPCall httpCall = this.getHTTPCall();
            Facet f = (Facet)httpCall.call(facetClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, body);
            logger.info("{} successfully created", (Object)f);
            return (F)f;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F updateFacet(Class<F> facetClass, F facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to update: {}", facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facet.getHeader().getUUID().toString());
            String body = ISMapper.marshal(facet);
            HTTPCall httpCall = this.getHTTPCall();
            Facet f = (Facet)httpCall.call(facetClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, body);
            logger.info("{} successfully updated", (Object)f);
            return (F)f;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Going to delete : {}", facet);
        return this.deleteFacet(facet.getHeader().getUUID());
    }

    @Override
    public boolean deleteFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"Facet", (Object)uuid.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Facet", uuid.toString(), deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> R createResource(Class<R> resourceClass, R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resourceClass.getSimpleName());
            String body = ISMapper.marshal(resource);
            HTTPCall httpCall = this.getHTTPCall();
            Resource r = (Resource)httpCall.call(resourceClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, body);
            logger.info("{} successfully created", (Object)r);
            return (R)r;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> R updateResource(Class<R> resourceClass, R resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to update: {}", resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resource.getHeader().getUUID().toString());
            String body = ISMapper.marshal(resource);
            HTTPCall httpCall = this.getHTTPCall();
            Resource r = (Resource)httpCall.call(resourceClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, body);
            logger.info("{} successfully updated", (Object)r);
            return (R)r;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("Going to delete {}", resource);
        return this.deleteResource(resource.getHeader().getUUID());
    }

    @Override
    public boolean deleteResource(UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"Resource", (Object)uuid.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Resource", uuid.toString(), deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(Class<C> consistsOfClass, C consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", consistsOf);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(consistsOfClass.getSimpleName());
            String body = ISMapper.marshal(consistsOf);
            HTTPCall httpCall = this.getHTTPCall();
            ConsistsOf c = (ConsistsOf)httpCall.call(consistsOfClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, body);
            logger.info("{} successfully created", (Object)c);
            return (C)c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws ResourceRegistryException {
        return this.deleteConsistsOf(consistsOf.getHeader().getUUID());
    }

    @Override
    public boolean deleteConsistsOf(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"ConsistsOf", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"ConsistsOf", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(Class<I> isRelatedToClass, I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", isRelatedTo);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(isRelatedToClass.getSimpleName());
            String body = ISMapper.marshal(isRelatedTo);
            HTTPCall httpCall = this.getHTTPCall();
            IsRelatedTo i = (IsRelatedTo)httpCall.call(isRelatedToClass, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, body);
            logger.info("{} successfully created", (Object)i);
            return (I)i;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws ResourceRegistryException {
        return this.deleteIsRelatedTo(isRelatedTo.getHeader().getUUID());
    }

    @Override
    public boolean deleteIsRelatedTo(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"IsRelatedTo", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"IsRelatedTo", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addResourceToContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean added = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Resource", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean addResourceToContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addResourceToContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean addFacetToContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean added = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Facet", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean addFacetToContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addFacetToContext(facet.getHeader().getUUID());
    }

    @Override
    public boolean removeResourceFromContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean removed = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Resource", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean removeResourceFromContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeResourceFromContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean removeFacetFromContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean removed = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Facet", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean removeFacetFromContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFacetFromContext(facet.getHeader().getUUID());
    }
}

