/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.util.UUID;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;

public interface ResourceRegistryPublisher {
    public <IE extends IdentifiableElement> IE create(IE var1) throws AlreadyPresentException, ResourceRegistryException;

    public String create(String var1) throws AlreadyPresentException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean exists(Class<IE> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean exists(IE var1) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public boolean exists(String var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <IE extends IdentifiableElement> IE read(IE var1) throws NotFoundException, ResourceRegistryException;

    public String read(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> IE update(IE var1) throws NotFoundException, ResourceRegistryException;

    public String update(String var1, String var2) throws NotFoundException, ResourceRegistryException;

    public String update(String var1) throws NotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean delete(IE var1) throws NotFoundException, ResourceRegistryException;

    public boolean delete(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <F extends Facet> F createFacet(F var1) throws FacetAlreadyPresentException, ResourceRegistryException;

    public String createFacet(String var1) throws FacetAlreadyPresentException, ResourceRegistryException;

    public <F extends Facet> F readFacet(F var1) throws FacetNotFoundException, ResourceRegistryException;

    public String readFacet(String var1, UUID var2) throws FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> F updateFacet(F var1) throws FacetNotFoundException, ResourceRegistryException;

    public String updateFacet(String var1) throws FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean deleteFacet(F var1) throws FacetNotFoundException, ResourceRegistryException;

    public boolean deleteFacet(String var1, UUID var2) throws FacetNotFoundException, ResourceRegistryException;

    public <R extends Resource> R createResource(R var1) throws ResourceAlreadyPresentException, ResourceRegistryException;

    public String createResource(String var1) throws ResourceAlreadyPresentException, ResourceRegistryException;

    public <R extends Resource> R readResource(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public String readResource(String var1, UUID var2) throws ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> R updateResource(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public String updateResource(String var1) throws ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean deleteResource(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public boolean deleteResource(String var1, UUID var2) throws ResourceNotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C var1) throws NotFoundException, ResourceRegistryException;

    public String createConsistsOf(String var1) throws NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C var1) throws NotFoundException, ResourceRegistryException;

    public String readConsistsOf(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C var1) throws NotFoundException, ResourceRegistryException;

    public String updateConsistsOf(String var1) throws NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C var1) throws ResourceRegistryException;

    public boolean deleteConsistsOf(String var1, UUID var2) throws ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I var1) throws ResourceNotFoundException, ResourceRegistryException;

    public String createIsRelatedTo(String var1) throws ResourceNotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I var1) throws NotFoundException, ResourceRegistryException;

    public String readIsRelatedTo(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I var1) throws NotFoundException, ResourceRegistryException;

    public String updateIsRelatedTo(String var1) throws NotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I var1) throws ResourceRegistryException;

    public boolean deleteIsRelatedTo(String var1, UUID var2) throws ResourceRegistryException;

    public boolean addToContext(UUID var1, String var2, UUID var3) throws NotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean addToContext(UUID var1, IE var2) throws NotFoundException, ResourceRegistryException;

    public boolean addToCurrentContext(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean addToCurrentContext(IE var1) throws NotFoundException, ResourceRegistryException;

    public boolean removeFromContext(UUID var1, String var2, UUID var3) throws NotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean removeFromContext(UUID var1, IE var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean removeFromCurrentContext(String var1, UUID var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <IE extends IdentifiableElement> boolean removeFromCurrentContext(IE var1) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean addResourceToContext(UUID var1, String var2, UUID var3) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean addResourceToContext(UUID var1, R var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean addResourceToCurrentContext(String var1, UUID var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean addResourceToCurrentContext(R var1) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean removeResourceFromContext(UUID var1, String var2, UUID var3) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean removeResourceFromContext(UUID var1, R var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean removeResourceFromCurrentContext(String var1, UUID var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean removeResourceFromCurrentContext(R var1) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean addFacetToContext(UUID var1, String var2, UUID var3) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean addFacetToContext(UUID var1, F var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean addFacetToCurrentContext(String var1, UUID var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean addFacetToCurrentContext(F var1) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean removeFacetFromContext(UUID var1, String var2, UUID var3) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean removeFacetFromContext(UUID var1, F var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public boolean removeFacetFromCurrentContext(String var1, UUID var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean removeFacetFromCurrentContext(F var1) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;
}

