/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.templates;

import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClient;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryQueryTemplateClientImpl
implements ResourceRegistryQueryTemplateClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryQueryTemplateClientImpl.class);
    protected final String address;

    public ResourceRegistryQueryTemplateClientImpl(String address) {
        this.address = address;
    }

    @Override
    public List<QueryTemplate> all() throws ResourceRegistryException {
        try {
            logger.trace("Going to list {}s", (Object)"QueryTemplate");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {}s are {}", (Object)"QueryTemplate", (Object)all);
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, QueryTemplate.class);
            return (List)ElementMapper.getObjectMapper().readValue(all, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryTemplate create(QueryTemplate queryTemplate) throws QueryTemplateAlreadyPresentException, ResourceRegistryException {
        try {
            String queryTemplateString = ElementMapper.marshal((Element)queryTemplate);
            String res = this.create(queryTemplateString);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String queryTemplate) throws QueryTemplateAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)queryTemplate);
            QueryTemplate qt = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(qt.getName());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(queryTemplate);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String queryTemplateName) throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(QueryTemplate queryTemplate) throws ResourceRegistryException {
        return this.exist(queryTemplate.getName());
    }

    @Override
    public QueryTemplate read(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.read(queryTemplate.getName());
    }

    @Override
    public QueryTemplate read(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String queryTemplate = this.readAsString(queryTemplateName);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readAsString(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"QueryTemplate", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryTemplate update(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String queryTemplateString = ElementMapper.marshal((Element)queryTemplate);
            String res = this.update(queryTemplateString);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to update: {}", (Object)queryTemplate);
            QueryTemplate qt = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(qt.getName());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(queryTemplate);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runGetString(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(name, "");
    }

    @Override
    public <E extends ERElement> List<E> run(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String ret = this.runGetString(name);
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, ERElement.class);
            return (List)ElementMapper.getObjectMapper().readValue(ret, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(queryTemplate.getName());
    }

    @Override
    public String run(String name, String params) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            if (params == null || params.compareTo("") == 0) {
                logger.trace("Going to run {} using default parameters", (Object)"QueryTemplate");
                params = null;
            } else {
                logger.trace("Going to run {} with the following parameters {}", (Object)"QueryTemplate", (Object)params);
            }
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(name);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(params);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("The result of the query is {}", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(String name, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String ret = this.run(name, objectMapper.writeValueAsString((Object)jsonNode));
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, ERElement.class);
            return (List)ElementMapper.getObjectMapper().readValue(ret, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(QueryTemplate queryTemplate, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(queryTemplate.getName(), jsonNode);
    }

    @Override
    public boolean delete(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.delete(queryTemplate.getName());
    }

    @Override
    public boolean delete(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryQueryTemplateClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with name {} {}", new Object[]{"QueryTemplate", queryTemplateName, deleted ? "successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

