/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientFactory.class);
    private static String FORCED_URL = null;

    public static String getCurrentContextFullName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    protected static void forceToURL(String url) {
        FORCED_URL = url;
    }

    public static ResourceRegistrySchemaClient create() {
        String address = null;
        address = FORCED_URL != null ? FORCED_URL : String.format("%s/%s", ServiceInstance.getServiceURL(), "resource-registry");
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistrySchemaClientImpl(address);
    }
}

