package org.gcube.informationsystem.resourceregistry.schema;

import org.gcube.informationsystem.resourceregistry.api.Constants;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceRegistrySchemaClientFactory {
	
	private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientFactory.class);

	public static ResourceRegistrySchemaClient create() {
		String address = String.format("%s/%s", ServiceInstance.getServiceURL(),Constants.SERVICE_NAME);
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistrySchemaClientImpl(address);
	}
	
}
