/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.http.GXHTTPUtility;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientImpl
implements ResourceRegistrySchemaClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected boolean includeMeta;

    public boolean includeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    private void addOptionalQueryParameters(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addIncludeMeta(queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        this.addOptionalQueryParameters(queryParams);
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private void addIncludeMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeMeta) {
            queryParams.put("includeMeta", Boolean.toString(this.includeMeta));
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPUtility.getGXHTTPStringRequest((String)this.address);
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistrySchemaClientImpl(String address) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        this.includeMeta = false;
    }

    @Override
    public <E extends Element> Type create(Class<E> clz) throws SchemaException, ResourceRegistryException {
        try {
            String typeDefinition = TypeMapper.serializeType(clz);
            String res = this.create(typeDefinition);
            return TypeMapper.deserializeTypeDefinition((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String typeDefinitition) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)typeDefinitition);
            Type typeDefinitionObj = TypeMapper.deserializeTypeDefinition((String)typeDefinitition);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeDefinitionObj.getName());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(typeDefinitition);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Element> boolean exist(Class<E> clz) throws ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clz);
            return this.exist(typeName);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String typeName) throws ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", Boolean.FALSE.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Element> List<Type> read(Class<E> clz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clz);
            String res = this.read(typeName, polymorphic);
            return TypeMapper.deserializeTypeDefinitions((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String typeName, Boolean polymorphic) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (polymorphic != null) {
                parameters.put("polymorphic", polymorphic.toString());
            }
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)typeName, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

