/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.http.GXHTTPUtility;
import org.gcube.informationsystem.model.knowledge.ModelKnowledge;
import org.gcube.informationsystem.model.knowledge.TypesDiscoverer;
import org.gcube.informationsystem.model.reference.ModelElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.schema.RRCCTypesDiscoverer;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.knowledge.TypeInformation;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientImpl
implements ResourceRegistrySchemaClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected TypesKnowledge typesKnowledge;
    protected boolean includeMeta;

    public boolean includeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    private void addOptionalQueryParameters(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addIncludeMeta(queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        this.addOptionalQueryParameters(queryParams);
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private void addIncludeMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeMeta) {
            queryParams.put("includeMeta", Boolean.toString(this.includeMeta));
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPUtility.getGXHTTPStringRequest((String)this.address);
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistrySchemaClientImpl(String address) {
        this(address, true);
    }

    public ResourceRegistrySchemaClientImpl(String address, boolean sharedModelKnowledge) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        this.includeMeta = false;
        this.typesKnowledge = sharedModelKnowledge ? TypesKnowledge.getInstance() : new TypesKnowledge();
        this.typesKnowledge.setTypesDiscoverer((TypesDiscoverer)new RRCCTypesDiscoverer(this));
    }

    @Override
    public ModelKnowledge<Type, TypeInformation> getModelKnowledge() {
        return this.typesKnowledge.getModelKnowledge();
    }

    @Override
    public void renewModelKnowledge() {
        this.typesKnowledge.renew();
    }

    @Override
    public <ME extends ModelElement> Type create(Class<ME> clz) throws SchemaException, ResourceRegistryException {
        try {
            String typeDefinition = TypeMapper.serializeType(clz);
            String res = this.create(typeDefinition);
            return TypeMapper.deserializeTypeDefinition((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String typeDefinitition) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)typeDefinitition);
            Type typeDefinitionObj = TypeMapper.deserializeTypeDefinition((String)typeDefinitition);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeDefinitionObj.getName());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(typeDefinitition);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            Type t = TypeMapper.deserializeTypeDefinition((String)c);
            this.typesKnowledge.getModelKnowledge().addType((Object)t);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ME extends ModelElement> boolean exist(Class<ME> clazz) throws ResourceRegistryException {
        return this.exist(TypeUtility.getTypeName(clazz));
    }

    @Override
    public boolean exist(String typeName) throws ResourceRegistryException {
        try {
            return this.typesKnowledge.getModelKnowledge().getTypeByName(typeName) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public List<Type> getTypeFromTypesKnowledge(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        return this.getTypeFromTypesKnowledge(typeName, polymorphic, -1);
    }

    public List<Type> getTypeFromTypesKnowledge(String typeName, int level) throws SchemaNotFoundException, ResourceRegistryException {
        return this.getTypeFromTypesKnowledge(typeName, true, level);
    }

    protected List<Type> addChildren(Node<Type> node, List<Type> types, int currentLevel, int maxLevel) {
        if (maxLevel >= 0 && maxLevel <= currentLevel) {
            return types;
        }
        Set children = node.getChildren();
        if (children != null && children.size() > 0) {
            for (Node child : children) {
                types.add((Type)child.getNodeElement());
                types = this.addChildren((Node<Type>)child, types, ++currentLevel, maxLevel);
            }
        }
        return types;
    }

    public List<Type> getTypeFromTypesKnowledge(String typeName, Boolean polymorphic, int level) throws SchemaNotFoundException, ResourceRegistryException {
        Node<Type> node = this.getTypeTreeNode(typeName);
        ArrayList<Type> types = new ArrayList<Type>();
        types.add((Type)node.getNodeElement());
        if (polymorphic.booleanValue()) {
            this.addChildren(node, types, 0, level);
        }
        return types;
    }

    @Override
    public String read(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            List<Type> types = this.getTypeFromTypesKnowledge(typeName, polymorphic);
            return TypeMapper.serializeTypeDefinitions(types);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> List<Type> read(Class<ME> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeFromTypesKnowledge(typeName, polymorphic);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public String read(String typeName, int level) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            List<Type> types = this.getTypeFromTypesKnowledge(typeName, level);
            return TypeMapper.serializeTypeDefinitions(types);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> List<Type> read(Class<ME> clazz, int level) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeFromTypesKnowledge(typeName, level);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public Node<Type> getTypeTreeNode(String typeName) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            Node node = null;
            try {
                node = this.typesKnowledge.getModelKnowledge().getNodeByName(typeName);
            }
            catch (RuntimeException e) {
                throw new SchemaNotFoundException((Throwable)e);
            }
            return node;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public <ME extends ModelElement> Node<Type> getTypeTreeNode(Class<ME> clazz) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clazz);
            return this.getTypeTreeNode(typeName);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public boolean existTypeFromServer(String typeName) throws ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", Boolean.FALSE.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <ME extends ModelElement> List<Type> getTypeFromServer(Class<ME> clz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String typeName = TypeUtility.getTypeName(clz);
            String json = this.getTypeFromServer(typeName, polymorphic);
            return TypeMapper.deserializeTypeDefinitions((String)json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String getTypeFromServer(String typeName, Boolean polymorphic) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (polymorphic != null) {
                parameters.put("polymorphic", polymorphic.toString());
            }
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)typeName, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

