/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.Query;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.QueryImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="access")
public class Access {
    private static Logger logger = LoggerFactory.getLogger(Access.class);
    protected Query queryManager = new QueryImpl();
    protected EntityManagement entityManager = new EntityManagementImpl();
    protected SchemaManagement schemaManager = new SchemaManagementImpl();

    @GET
    public String query(@QueryParam(value="query") String query, @QueryParam(value="fetchPlan") String fetchPlan) throws InvalidQueryException {
        logger.info("Requested query (fetch plan {}):\n{}", (Object)fetchPlan, (Object)query);
        return this.queryManager.execute(query, fetchPlan);
    }

    @GET
    @Path(value="facetInstance/{facetId}")
    public String getFacet(@PathParam(value="facetId") String facetId) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Requested Facet with id {}", (Object)facetId);
        return this.entityManager.readFacet(facetId);
    }

    @GET
    @Path(value="facetSchema/{facetType}")
    public String getFacetSchema(@PathParam(value="facetType") String facetType) throws SchemaNotFoundException {
        logger.info("Requested Facet Schema for type {}", (Object)facetType);
        return this.schemaManager.getFacetSchema(facetType);
    }

    @GET
    @Path(value="resourceInstance/{resourceId}")
    public String getResource(@PathParam(value="resourceId") String resourceId) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("Requested Resource with id {}", (Object)resourceId);
        return this.entityManager.readResource(resourceId);
    }

    @GET
    @Path(value="resourceSchema/{resourceType}")
    public String getResourceSchema(@PathParam(value="resourceType") String resourceType) throws SchemaNotFoundException {
        logger.info("Requested Resource Schema for type {}", (Object)resourceType);
        return this.schemaManager.getResourceSchema(resourceType);
    }
}

