/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.utils;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utility {
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);

    public static String orientVertexToJsonString(OrientVertex orientVertex) {
        ODocument oRecord = orientVertex.getRecord();
        return oRecord.toJSON();
    }

    public static String vertexToJsonString(Vertex vertex, boolean raw) throws JSONException {
        if (raw) {
            return GraphSONUtility.jsonFromElement((Element)vertex, (Set)vertex.getPropertyKeys(), (GraphSONMode)GraphSONMode.EXTENDED).toString();
        }
        HashSet keys = new HashSet(vertex.getPropertyKeys());
        for (String key : vertex.getPropertyKeys()) {
            if (!key.startsWith("_")) continue;
            keys.remove(key);
        }
        return GraphSONUtility.jsonFromElement((Element)vertex, keys, (GraphSONMode)GraphSONMode.COMPACT).toString();
    }

    public static String vertexToJsonString(Vertex vertex) {
        try {
            return Utility.vertexToJsonString((Vertex)vertex, (boolean)true);
        }
        catch (Exception e) {
            return String.valueOf(vertex);
        }
    }

    public static String orientEdgeToJsonString(OrientEdge orientEdge) {
        ODocument oRecord = orientEdge.getRecord();
        return oRecord.toJSON();
    }

    public static String edgeToJsonString(Edge edge, boolean raw) throws JSONException {
        if (raw) {
            return GraphSONUtility.jsonFromElement((Element)edge, (Set)edge.getPropertyKeys(), (GraphSONMode)GraphSONMode.EXTENDED).toString();
        }
        HashSet keys = new HashSet(edge.getPropertyKeys());
        for (String key : edge.getPropertyKeys()) {
            if (!key.startsWith("_")) continue;
            keys.remove(key);
        }
        return GraphSONUtility.jsonFromElement((Element)edge, keys, (GraphSONMode)GraphSONMode.COMPACT).toString();
    }

    public static String edgeToJsonString(Edge edge) {
        try {
            return Utility.edgeToJsonString((Edge)edge, (boolean)true);
        }
        catch (Exception e) {
            return String.valueOf(edge);
        }
    }

    public static Vertex getEntityByUUID(OrientGraph orientGraph, String entityType, String uuid) throws ResourceRegistryException {
        String select;
        OSQLSynchQuery osqlSynchQuery;
        Iterable vertexes;
        if (entityType == null) {
            entityType = Entity.NAME;
        }
        if ((vertexes = (Iterable)orientGraph.command((OCommandRequest)(osqlSynchQuery = new OSQLSynchQuery(select = "SELECT FROM " + entityType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid + "\""))).execute(new Object[0])) == null || !vertexes.iterator().hasNext()) {
            String error = String.format("No %s with UUID %s was found", entityType, uuid);
            logger.info(error);
            throw new EntityException(error);
        }
        Iterator iterator = vertexes.iterator();
        Vertex entity = (Vertex)iterator.next();
        logger.trace("{} with {} is : {}", new Object[]{entityType, uuid, Utility.vertexToJsonString((Vertex)entity)});
        if (iterator.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + entityType + " with uuid " + uuid + ". This is a fatal error please contact Admnistrator");
        }
        return entity;
    }

    public static Edge getRelationByUUID(OrientGraph orientGraph, String relationType, String uuid) throws ResourceRegistryException {
        String select;
        OSQLSynchQuery osqlSynchQuery;
        Iterable edges;
        if (relationType == null) {
            relationType = Relation.class.getSimpleName();
        }
        if ((edges = (Iterable)orientGraph.command((OCommandRequest)(osqlSynchQuery = new OSQLSynchQuery(select = "SELECT FROM " + relationType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid + "\""))).execute(new Object[0])) == null || !edges.iterator().hasNext()) {
            String error = String.format("No %s with UUID %s was found", relationType, uuid);
            logger.info(error);
            throw new FacetNotFoundException(error);
        }
        Iterator iterator = edges.iterator();
        Edge relation = (Edge)iterator.next();
        logger.trace("{} with {} is : {}", new Object[]{relationType, uuid, Utility.edgeToJsonString((Edge)relation)});
        if (iterator.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + relationType + " with uuid " + uuid + ". This is a fatal error please contact Admnistrator");
        }
        return relation;
    }
}

