/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.SchemaManager;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="entity")
public class EntityManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";
    public static final String SOURCE_ID_PATH_PARAM = "sourceId";
    public static final String TARGET_ID_PATH_PARAM = "targetId";
    protected EntityManagement entityManager = new EntityManagementImpl();

    @PUT
    @Path(value="facet/{type}")
    public String createFacet(@PathParam(value="type") String type, @QueryParam(value="definition") String definition) throws EntityException, ResourceRegistryException {
        logger.trace("requested facet creation for type {} defined by {} ", (Object)type, (Object)definition);
        return this.entityManager.createFacet(type, definition);
    }

    @POST
    @Path(value="facet/{id}")
    public String updateFacet(@PathParam(value="id") String uuid, @QueryParam(value="definition") String definition) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("requested facet update for id {} with {}", (Object)uuid, (Object)definition);
        return this.entityManager.updateFacet(uuid, definition);
    }

    @DELETE
    @Path(value="facet/{id}")
    public boolean deleteFacet(@PathParam(value="id") String uuid) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("Requested to delete Facet with id {}", (Object)uuid);
        return this.entityManager.deleteFacet(uuid);
    }

    @PUT
    @Path(value="resource/{type}")
    public String createResource(@PathParam(value="type") String type, @QueryParam(value="definition") String definition) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("requested resource creation for type {} with json {}", (Object)type, (Object)definition);
        return this.entityManager.createResource(type, definition);
    }

    @DELETE
    @Path(value="resource/{id}")
    public boolean deleteResource(@PathParam(value="id") String uuid) throws ResourceNotFoundException, Exception {
        logger.trace("requested resource deletion for id {}", (Object)uuid);
        return this.entityManager.deleteResource(uuid);
    }

    @PUT
    @Path(value="consistsOf/source/{sourceId}/target/{targetId}")
    public String attachFacet(@PathParam(value="sourceId") String resourceUUID, @PathParam(value="targetId") String facetUUID, @QueryParam(value="type") String type, @QueryParam(value="properties") String properties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.trace("requested to attach resource {} to facet {} ({} Type {}) with properties {}", new Object[]{resourceUUID, facetUUID, ConsistsOf.class.getSimpleName(), type, properties});
        return this.entityManager.attachFacet(resourceUUID, facetUUID, type, properties);
    }

    @DELETE
    @Path(value="consistsOf/{id}")
    public boolean detachFacet(@PathParam(value="id") String consistOfUUID) throws ResourceRegistryException {
        logger.trace("requested to detach {}", (Object)consistOfUUID);
        return this.entityManager.detachFacet(consistOfUUID);
    }

    @PUT
    @Path(value="isRelatedTo/source/{sourceId}/target/{targetId}")
    public String attachResource(@PathParam(value="sourceId") String sourceResourceUUID, @PathParam(value="targetId") String targetResourceUUID, @QueryParam(value="type") String type, @QueryParam(value="properties") String properties) throws ResourceNotFoundException, ResourceRegistryException {
        logger.trace("requested to attach source resource {} and target resource {} ({} Type {}) with properties {}", new Object[]{sourceResourceUUID, targetResourceUUID, IsRelatedTo.class.getSimpleName(), type, properties});
        return this.entityManager.attachResource(sourceResourceUUID, targetResourceUUID, type, properties);
    }

    @DELETE
    @Path(value="isRelatedTo/{id}")
    public boolean detachResource(@PathParam(value="id") String relatedToUUID) throws ResourceRegistryException {
        logger.trace("requested to detach {}", (Object)relatedToUUID);
        return this.entityManager.detachResource(relatedToUUID);
    }
}

