/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.utils.ContextUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityManagementImpl
implements EntityManagement {
    private static Logger logger = LoggerFactory.getLogger(EntityManagementImpl.class);

    public Vertex getEntity(OrientGraph orientGraph, String uuid, String entityType, Class<? extends Entity> entityClass) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            if (entityType == null || entityType.compareTo("") == 0) {
                if (Facet.class.isAssignableFrom(entityClass)) {
                    entityType = "Facet";
                }
                if (Resource.class.isAssignableFrom(entityClass)) {
                    entityType = "Resource";
                }
            }
            return Utility.getEntityByUUID((OrientGraph)orientGraph, (String)entityType, (String)uuid);
        }
        catch (ResourceRegistryException e) {
            if (Facet.class.isAssignableFrom(entityClass)) {
                throw new FacetNotFoundException(e.getMessage());
            }
            if (Resource.class.isAssignableFrom(entityClass)) {
                throw new ResourceNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    public Edge getRelation(OrientGraph orientGraph, String uuid, String relationType, Class<? extends Relation> relationClass) throws ResourceRegistryException {
        try {
            if (relationType == null || relationType.compareTo("") == 0) {
                if (IsRelatedTo.class.isAssignableFrom(relationClass)) {
                    relationType = "IsRelatedTo";
                }
                if (ConsistsOf.class.isAssignableFrom(relationClass)) {
                    relationType = "ConsistsOf";
                }
            }
            return Utility.getRelationByUUID((OrientGraph)orientGraph, (String)relationType, (String)uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    private static String lowerCaseFirstCharacter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    private static Header getHeader(JsonNode jsonNode) throws JsonParseException, JsonMappingException, IOException {
        if (jsonNode.has("header")) {
            JsonNode header = jsonNode.get("header");
            if (header.isNull()) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            return (Header)mapper.readValue(header.toString(), Header.class);
        }
        return null;
    }

    private static void checkEmbeddedType(JsonNode jsonNode) throws ResourceRegistryException {
        if (jsonNode.has("@class")) {
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(type, "Embedded");
            Header header = null;
            try {
                header = EntityManagementImpl.getHeader((JsonNode)jsonNode);
            }
            catch (Exception e) {
                logger.warn("An invalid Header has been provided. An embedded object cannot have an Header.  It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
            if (header != null) {
                logger.warn("An embedded object cannot have an Header. It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
        }
    }

    public static Object getObejctFromElement(JsonNode value) throws ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                EntityManagementImpl.checkEmbeddedType((JsonNode)value);
                return null;
            }
            case 2: {
                ArrayList<Object> array = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode arrayNode = (JsonNode)arrayElement.next();
                    Object objectNode = EntityManagementImpl.getObejctFromElement((JsonNode)arrayNode);
                    if (objectNode == null) continue;
                    array.add(objectNode);
                }
                return array;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (key.compareTo("header") == 0 || key.startsWith("@") || key.startsWith("_") || ignoreKeys.contains(key)) continue;
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = EntityManagementImpl.getObejctFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                logger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createRelation(OrientGraph orientGraph, Vertex resource, JsonNode relationArray, Class<? extends Relation> relation) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        Iterator iterator = relationArray.elements();
        while (iterator.hasNext()) {
            String error;
            JsonNode node = (JsonNode)iterator.next();
            JsonNode target = node.get("target");
            Header targetHeader = null;
            try {
                targetHeader = EntityManagementImpl.getHeader((JsonNode)target);
            }
            catch (IOException e) {
                new ResourceRegistryException((Throwable)e);
            }
            Class<Facet> targetClass = null;
            Vertex targetVertex = null;
            if (targetHeader == null) {
                if (!ConsistsOf.class.isAssignableFrom(relation)) {
                    error = String.format("%s %s must already exist. The UUID must be provided in the %s of %s json respresentation", "target", "Resource", "Header", "IsRelatedTo");
                    logger.error(error);
                    throw new ResourceRegistryException(error);
                }
                targetVertex = this.createVertexEntity(orientGraph, EntityManagementImpl.getClassProperty((JsonNode)target), Facet.class, target.toString(), true);
                targetClass = Facet.class;
                targetHeader = (Header)targetVertex.getProperty("header");
            } else {
                if (ConsistsOf.class.isAssignableFrom(relation)) {
                    targetClass = Facet.class;
                } else {
                    if (!IsRelatedTo.class.isAssignableFrom(relation)) {
                        error = String.format("%s Unsupported %s creation", relation.toString(), "Relation");
                        logger.error(error);
                        throw new ResourceRegistryException(error);
                    }
                    targetClass = Resource.class;
                }
                String targetUUID = targetHeader.getUUID().toString();
                String entityType = EntityManagementImpl.getClassProperty((JsonNode)target);
                targetVertex = this.getEntity(orientGraph, targetUUID, entityType, targetClass);
            }
            String relationType = EntityManagementImpl.getClassProperty((JsonNode)node);
            HashSet<String> ignoreKeys = new HashSet<String>();
            ignoreKeys.add("target");
            ignoreKeys.add("source");
            Map edgeProperties = null;
            try {
                edgeProperties = EntityManagementImpl.getPropertyMap((JsonNode)node, ignoreKeys);
            }
            catch (Exception e) {
                String error2 = "Error while parsing json to get Relation properties";
                logger.error(error2, (Throwable)e);
                throw new ResourceRegistryException(error2, (Throwable)e);
            }
            this.createEdgeRelation(orientGraph, resource, targetVertex, relationType, relation, edgeProperties, true);
        }
        return;
    }

    public Vertex createVertexEntity(String entityType, Class<? extends Entity> entity, String jsonRepresentation, boolean deferredCommit) throws ResourceRegistryException {
        OrientGraph orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        return this.createVertexEntity(orientGraph, entityType, entity, jsonRepresentation, deferredCommit);
    }

    public Vertex createVertexEntity(OrientGraph orientGraph, String entityType, Class<? extends Entity> entity, String jsonRepresentation, boolean deferredCommit) throws ResourceRegistryException {
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(entityType, entity.getSimpleName());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            if (type != null && type.compareTo(entityType) != 0) {
                String error = String.format("Declared resourceType does not match with json representation %s!=%s", entityType, type);
                logger.trace(error);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertex = orientGraph.addVertex((Object)("class:" + entityType));
            Header entityHeader = EntityManagementImpl.getHeader((JsonNode)jsonNode);
            if (entityHeader != null) {
                vertex.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Vertex)vertex, null);
            }
            if (!Resource.class.isAssignableFrom(entity)) {
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (((String)entry.getKey()).compareTo("header") == 0 || ((String)entry.getKey()).startsWith("@") || ((String)entry.getKey()).startsWith("_")) continue;
                    JsonNode value = (JsonNode)entry.getValue();
                    vertex.setProperty((String)entry.getKey(), (Object)value.asText());
                }
            }
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)vertex);
            vertex.save();
            if (!deferredCommit) {
                orientGraph.commit();
                logger.trace("Created {} is {} orientVertexToJsonString", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)vertex, (boolean)true));
            }
            OrientVertex orientVertex = vertex;
            return orientVertex;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Creating " + entityType + " with " + jsonRepresentation, e.getCause());
        }
        finally {
            if (orientGraph != null && !deferredCommit) {
                orientGraph.shutdown();
            }
        }
    }

    public Edge createEdgeRelation(String sourceUUID, Class<? extends Entity> sourceClass, String targetUUID, Class<? extends Entity> targetClass, String relationType, Class<? extends Relation> relationBaseClass, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        if (relationType == null || relationType.compareTo("") == 0) {
            throw new ResourceRegistryException(Relation.class.getSimpleName() + "type cannot be empty or null");
        }
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex source = this.getEntity(orientGraph, sourceUUID, null, sourceClass);
            Vertex target = this.getEntity(orientGraph, targetUUID, null, targetClass);
            Map edgeProperties = new HashMap();
            if (jsonProperties != null && jsonProperties.compareTo("") != 0) {
                try {
                    HashSet<String> ignoreKeys = new HashSet<String>();
                    ignoreKeys.add("source");
                    ignoreKeys.add("target");
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode jsonNode = mapper.readTree(jsonProperties);
                    edgeProperties = EntityManagementImpl.getPropertyMap((JsonNode)jsonNode, ignoreKeys);
                }
                catch (Exception e) {
                    new ResourceRegistryException("Error while setting Relation Properties", (Throwable)e);
                }
            }
            return this.createEdgeRelation(orientGraph, source, target, relationType, relationBaseClass, edgeProperties, false);
        }
        catch (ResourceNotFoundException rnfe) {
            throw rnfe;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public Edge createEdgeRelation(OrientGraph orientGraph, Vertex source, Vertex target, String relationType, Class<? extends Relation> relationBaseClass, Map<String, Object> edgeProperties, boolean deferredCommit) throws ResourceRegistryException {
        try {
            SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
            schemaManagement.getTypeSchema(relationType, relationBaseClass.getSimpleName());
            if (relationType == null || relationType.compareTo("") == 0) {
                throw new ResourceRegistryException(Relation.class.getSimpleName() + " Type cannot be empty or null");
            }
            logger.trace("Creating {} ({}) beetween {} -> {}", new Object[]{Relation.class.getSimpleName(), relationType, Utility.toJsonString((Element)source, (boolean)true), Utility.toJsonString((Element)target, (boolean)true)});
            OrientEdge edge = orientGraph.addEdge(null, source, target, relationType);
            for (String key : edgeProperties.keySet()) {
                try {
                    edge.setProperty(key, edgeProperties.get(key));
                }
                catch (Exception e) {
                    String error = String.format("Error while setting property %s : %s", key, edgeProperties.get(key).toString());
                    logger.error(error);
                    throw new ResourceRegistryException(error, (Throwable)e);
                }
            }
            HeaderUtility.addHeader((Edge)edge, null);
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Edge)edge);
            edge.save();
            if (!deferredCommit) {
                orientGraph.commit();
            }
            OrientEdge orientEdge = edge;
            return orientEdge;
        }
        catch (ResourceRegistryException rre) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null && !deferredCommit) {
                orientGraph.shutdown();
            }
        }
    }

    public String createFacet(String facetType, String jsonRepresentation) throws ResourceRegistryException {
        Vertex vertex = this.createVertexEntity(facetType, Facet.class, jsonRepresentation, false);
        return Utility.toJsonString((OrientElement)((OrientVertex)vertex), (boolean)false);
    }

    public String readFacet(String uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.readFacet(uuid, "Facet");
    }

    public String readFacet(String uuid, String facetType) throws FacetNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex facet = this.getEntity(orientGraph, uuid, facetType, Facet.class);
            logger.trace("{} of type {} with UUID {} is {}", new Object[]{"Facet", facetType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true);
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Exception e) {
            throw new ResourceRegistryException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String updateFacet(String uuid, String jsonRepresentation) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            String entityType = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            Vertex facet = this.getEntity(orientGraph, uuid, entityType, Facet.class);
            Set oldKeys = facet.getPropertyKeys();
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String key = (String)entry.getKey();
                if (key.startsWith("_")) {
                    oldKeys.remove(key);
                    continue;
                }
                if (key.compareTo("header") == 0) {
                    oldKeys.remove(key);
                    continue;
                }
                JsonNode value = (JsonNode)entry.getValue();
                facet.setProperty(key, (Object)value.asText());
                oldKeys.remove(key);
            }
            for (String key : oldKeys) {
                if (key.startsWith("_")) continue;
                facet.removeProperty(key);
            }
            ((OrientVertex)facet).save();
            orientGraph.commit();
            logger.trace("{} with UUID {} has been updated {}", new Object[]{"Facet", uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)false);
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Updating Facet", e.getCause());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteFacet(String uuid) throws FacetNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex facet = this.getEntity(orientGraph, uuid, "Facet", Facet.class);
            facet.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachFacet(String resourceUUID, String facetUUID, String consistOfType, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        Edge edge = this.createEdgeRelation(resourceUUID, Resource.class, facetUUID, Facet.class, consistOfType, ConsistsOf.class, jsonProperties);
        return Utility.toJsonString((OrientElement)((OrientEdge)edge), (boolean)false);
    }

    public boolean detachFacet(String consistOfUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, consistOfUUID, "ConsistsOf", ConsistsOf.class);
            edge.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachResource(String sourceResourceUuid, String targetResourceUuid, String relatedToType, String jsonProperties) throws ResourceNotFoundException, ResourceRegistryException {
        Edge edge = this.createEdgeRelation(sourceResourceUuid, Resource.class, targetResourceUuid, Resource.class, relatedToType, IsRelatedTo.class, jsonProperties);
        return Utility.toJsonString((OrientElement)((OrientEdge)edge), (boolean)false);
    }

    public boolean detachResource(String relatedToUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, relatedToUUID, "IsRelatedTo", IsRelatedTo.class);
            edge.remove();
            orientGraph.commit();
        }
        catch (FacetNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    private static String marshallResource(Vertex vertex) throws JSONException {
        JSONObject jsonObject = Utility.toJsonObject((OrientElement)((OrientVertex)vertex), (boolean)true);
        JSONArray consistsOfArray = new JSONArray();
        Iterable edges = vertex.getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            String edgeType = edge.getLabel();
            try {
                SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
                schemaManagement.getTypeSchema(edgeType, "ConsistsOf");
                JSONObject jsonObjectEdge = Utility.toJsonObject((OrientElement)((OrientEdge)edge), (boolean)true);
                Vertex facetVertex = edge.getVertex(Direction.IN);
                jsonObjectEdge.put("target", (Object)Utility.toJsonObject((OrientElement)((OrientVertex)facetVertex), (boolean)true));
                consistsOfArray.put((Object)jsonObjectEdge);
            }
            catch (SchemaNotFoundException schemaNotFoundException) {}
        }
        jsonObject.put(EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf"), (Object)consistsOfArray);
        return jsonObject.toString();
    }

    public String createResource(String resourceType, String jsonRepresentation) throws ResourceRegistryException {
        logger.trace("Trying to create {} : {}", (Object)resourceType, (Object)jsonRepresentation);
        OrientGraph orientGraph = null;
        try {
            JsonNode jsonNodeArray;
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.createVertexEntity(orientGraph, resourceType, Resource.class, jsonRepresentation, true);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String property = EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf");
            if (jsonNode.has(property)) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelation(orientGraph, resource, jsonNodeArray, ConsistsOf.class);
            }
            if (jsonNode.has(property = EntityManagementImpl.lowerCaseFirstCharacter((String)"IsRelatedTo"))) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelation(orientGraph, resource, jsonNodeArray, IsRelatedTo.class);
            }
            orientGraph.commit();
            String string = EntityManagementImpl.marshallResource((Vertex)resource);
            return string;
        }
        catch (ResourceRegistryException rre) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String readResource(String uuid) throws ResourceNotFoundException {
        return this.readResource(uuid, "Resource");
    }

    public String readResource(String uuid, String resourceType) throws ResourceNotFoundException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex resource = this.getEntity(orientGraph, uuid, resourceType, Resource.class);
            logger.trace("{} of type {} with UUID {} is {}", new Object[]{"Resource", resourceType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)resource), (boolean)true)});
            String string = EntityManagementImpl.marshallResource((Vertex)resource);
            return string;
        }
        catch (ResourceNotFoundException rnfe) {
            throw rnfe;
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteResource(String uuid) throws ResourceNotFoundException, ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.getEntity(orientGraph, uuid, null, Resource.class);
            resource.remove();
            orientGraph.commit();
        }
        catch (ResourceNotFoundException fnfe) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }
}

