/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    public static final String DEFAULT_WRITER_ROLE = "writer";
    public static final String DEFAULT_READER_ROLE = "reader";

    public static void addToSecurityContext(OrientGraph orientGraph, Vertex vertex, UUID context) {
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Vertex)vertex, (UUID)context);
    }

    public static void addToSecurityContext(OSecurity oSecurity, Vertex vertex, UUID context) {
        OrientVertex orientVertex = (OrientVertex)vertex;
        SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)orientVertex.getRecord(), (UUID)context);
        orientVertex.save();
        Iterable iterable = vertex.getEdges(Direction.BOTH, new String[0]);
        for (OrientEdge edge : iterable) {
            SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)edge.getRecord(), (UUID)context);
            edge.save();
        }
    }

    public static void addToSecurityContext(OrientGraph orientGraph, Edge edge, UUID context) {
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Edge)edge, (UUID)context);
    }

    public static void addToSecurityContext(OSecurity oSecurity, Edge edge, UUID context) {
        OrientEdge orientEdge = (OrientEdge)edge;
        SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)orientEdge.getRecord(), (UUID)context);
    }

    protected static void allowSecurityContextRoles(OSecurity oSecurity, ODocument oDocument, UUID context) {
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context));
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context));
        oDocument.save();
    }

    public static void createSecurityContext(OrientGraph orientGraph, UUID context) {
        ODatabaseDocumentTx oDatabaseDocumentTx = orientGraph.getRawGraph();
        OSecurity oSecurity = oDatabaseDocumentTx.getMetadata().getSecurity();
        ORole writer = oSecurity.getRole("writer");
        ORole reader = oSecurity.getRole("reader");
        String writeRoleName = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context);
        ORole writerRole = oSecurity.createRole(writeRoleName, writer, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        writerRole.save();
        logger.trace("{} created", (Object)writerRole);
        String readerRoleName = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context);
        ORole readerRole = oSecurity.createRole(readerRoleName, reader, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        readerRole.save();
        logger.trace("{} created", (Object)readerRole);
        String writerUserName = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (UUID)context);
        OUser writerUser = oSecurity.createUser(writerUserName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(SecurityContextMapper.PermissionMode.WRITER), new ORole[]{writerRole});
        writerUser.save();
        logger.trace("{} created", (Object)writerUser);
        String readerUserName = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (UUID)context);
        OUser readerUser = oSecurity.createUser(readerUserName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(SecurityContextMapper.PermissionMode.READER), new ORole[]{readerRole});
        readerUser.save();
        logger.trace("{} created", (Object)readerUser);
        oDatabaseDocumentTx.commit();
        logger.trace("Security Context (roles and users) with UUID {} successfully created", (Object)context.toString());
    }

    public static void deleteSecurityContext(OrientGraph orientGraph, UUID context, boolean commit) {
        logger.trace("Going to remove Security Context (roles and users) with UUID {}", (Object)context.toString());
        ODatabaseDocumentTx oDatabaseDocumentTx = orientGraph.getRawGraph();
        OSecurity oSecurity = oDatabaseDocumentTx.getMetadata().getSecurity();
        String user = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (UUID)context);
        boolean dropped = oSecurity.dropUser(user);
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)user);
        } else {
            logger.error("{} was not dropped successfully", (Object)user);
        }
        user = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (UUID)context);
        dropped = oSecurity.dropUser(user);
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)user);
        } else {
            logger.error("{} was not dropped successfully", (Object)user);
        }
        String role = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context);
        dropped = oSecurity.dropRole(role);
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)role);
        } else {
            logger.error("{} was not dropped successfully", (Object)role);
        }
        role = SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (UUID)context);
        dropped = oSecurity.dropRole(role);
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)role);
        } else {
            logger.error("{} was not dropped successfully", (Object)role);
        }
        if (commit) {
            oDatabaseDocumentTx.commit();
        }
        logger.trace("Security Context (roles and users) with UUID {} successfully removed", (Object)context.toString());
    }
}

