/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.Query;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.QueryImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="access")
public class Access {
    private static Logger logger = LoggerFactory.getLogger(Access.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";
    protected Query queryManager = new QueryImpl();
    protected EntityManagement entityManager = new EntityManagementImpl();
    protected SchemaManagement schemaManager = new SchemaManagementImpl();

    @GET
    @Produces(value={"application/json"})
    public String query(@QueryParam(value="query") String query, @QueryParam(value="limit") int limit, @QueryParam(value="fetchPlan") String fetchPlan) throws InvalidQueryException {
        logger.info("Requested query (fetch plan {}, limit : {}):\n{}", new Object[]{fetchPlan, limit, query});
        return this.queryManager.query(query, limit, fetchPlan);
    }

    @GET
    @Path(value="facet/instance/{id}")
    @Produces(value={"application/json"})
    public String getFacet(@PathParam(value="id") String facetId) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Requested Facet with id {}", (Object)facetId);
        return this.entityManager.readFacet(UUID.fromString(facetId));
    }

    @GET
    @Path(value="facet/schema/{type}")
    @Produces(value={"application/json"})
    public String getFacetSchema(@PathParam(value="type") String facetType) throws SchemaNotFoundException {
        logger.info("Requested Facet Schema for type {}", (Object)facetType);
        return this.schemaManager.getFacetSchema(facetType);
    }

    @GET
    @Path(value="resource/instance/{id}")
    @Produces(value={"application/json"})
    public String getResource(@PathParam(value="id") String resourceId) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("Requested Resource with id {}", (Object)resourceId);
        return this.entityManager.readResource(UUID.fromString(resourceId));
    }

    @GET
    @Path(value="resource/schema/{type}")
    @Produces(value={"application/json"})
    public String getResourceSchema(@PathParam(value="type") String resourceType) throws SchemaNotFoundException {
        logger.info("Requested Resource Schema for type {}", (Object)resourceType);
        return this.schemaManager.getResourceSchema(resourceType);
    }
}

