/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.resourceregistry.api.ContextManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InternalException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.ContextManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="context")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);
    public static final String ID_PATH_PARAM = "id";
    protected ContextManagement contextManager = new ContextManagementImpl();

    @PUT
    @Produces(value={"application/json"})
    public String create(@QueryParam(value="parentContextId") String parentUUID, @QueryParam(value="name") String name) throws ContextCreationException, InternalException {
        logger.trace("requested to create context with name : {} ", (Object)name);
        return this.contextManager.create(UUID.fromString(parentUUID), name);
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public boolean delete(@PathParam(value="id") String uuid) throws ContextNotFoundException, ContextException {
        logger.trace("requested to delete context with id {} ", (Object)uuid);
        return this.contextManager.delete(UUID.fromString(uuid));
    }

    @POST
    @Path(value="rename/{id}")
    @Produces(value={"application/json"})
    public String rename(@PathParam(value="id") String uuid, @QueryParam(value="name") String name) throws ContextNotFoundException, ContextException {
        logger.trace("requested to rename context id {} with {} ", (Object)uuid, (Object)name);
        return this.contextManager.rename(UUID.fromString(uuid), name);
    }

    @POST
    @Path(value="move/{id}")
    @Produces(value={"application/json"})
    public String move(@PathParam(value="id") String uuid, @QueryParam(value="parentContextId") String newParentUUID) throws ContextNotFoundException, ContextException {
        logger.trace("requested to move context id {} with new parend id {} ", (Object)uuid, (Object)newParentUUID);
        return this.contextManager.move(UUID.fromString(newParentUUID), UUID.fromString(uuid));
    }
}

