/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InternalException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotAllowedException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ObjectNotFound;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;

@Provider
public class ResourceRegistryExceptionMapper
implements ExceptionMapper<ResourceRegistryException> {
    public Response toResponse(ResourceRegistryException exception) {
        Response.Status status = Response.Status.BAD_REQUEST;
        String entity = exception.getMessage();
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (ObjectNotFound.class.isAssignableFrom(exception.getClass())) {
            status = Response.Status.NOT_FOUND;
        } else if (NotAllowedException.class.isAssignableFrom(exception.getClass())) {
            status = Response.Status.FORBIDDEN;
        } else if (InternalException.class.isAssignableFrom(exception.getClass())) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)entity).type(mediaType).build();
    }
}

