/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import org.gcube.informationsystem.impl.utils.discovery.ERAction;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRegistrationAction
implements ERAction {
    private static Logger logger = LoggerFactory.getLogger(EntityRegistrationAction.class);
    protected SchemaManagement schemaManagement = new SchemaManagementImpl();

    public <R extends Relation<? extends Entity, ? extends Entity>> void manageRelationClass(Class<R> r) throws Exception {
        try {
            String json = TypeBinder.serializeType(r);
            logger.trace(json);
            if (ConsistsOf.class.isAssignableFrom(r)) {
                this.schemaManagement.registerConsistOfSchema(json);
            } else if (IsRelatedTo.class.isAssignableFrom(r)) {
                this.schemaManagement.registerRelatedToSchema(json);
            } else {
                this.schemaManagement.registerRelationSchema(json);
            }
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Relation", r.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends Entity> void manageEntityClass(Class<E> e) throws Exception {
        try {
            String json = TypeBinder.serializeType(e);
            logger.trace(json);
            if (Facet.class.isAssignableFrom(e)) {
                this.schemaManagement.registerFacetSchema(json);
            } else if (Resource.class.isAssignableFrom(e)) {
                this.schemaManagement.registerResourceSchema(json);
            } else {
                this.schemaManagement.registerEntitySchema(json);
            }
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Entity", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends Embedded> void manageEmbeddedClass(Class<E> e) throws Exception {
        if (e == Embedded.class) {
            logger.trace("Discarding {} because is just a convenient interface", e);
            return;
        }
        try {
            String json = TypeBinder.serializeType(e);
            logger.trace(json);
            this.schemaManagement.registerEmbeddedTypeSchema(json);
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Embedded", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }
}

