/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="schema")
public class SchemaManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    protected SchemaManagement schemaManager = new SchemaManagementImpl();

    @PUT
    @Path(value="embedded")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String registerEmbeddedTypeSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Embedded registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerEmbeddedTypeSchema(jsonSchema);
    }

    @PUT
    @Path(value="facet")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String registerFacetSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Facet registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerFacetSchema(jsonSchema);
    }

    @PUT
    @Path(value="resource")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String registerResourceSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Resource registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerResourceSchema(jsonSchema);
    }

    @PUT
    @Path(value="consistOf")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String registerConsistOfSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested ConsistOf registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerConsistOfSchema(jsonSchema);
    }

    @PUT
    @Path(value="relatedTo")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String registerRelatedToSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested RelatedTo registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerRelatedToSchema(jsonSchema);
    }
}

