/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ExceptionMapper;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;

@Provider
public class ResourceRegistryExceptionMapper
implements javax.ws.rs.ext.ExceptionMapper<ResourceRegistryException> {
    public Response toResponse(ResourceRegistryException exception) {
        Response.Status status = Response.Status.BAD_REQUEST;
        if (ERNotFoundException.class.isAssignableFrom(exception.getClass())) {
            status = Response.Status.NOT_FOUND;
        } else if (ERAlreadyPresentException.class.isAssignableFrom(exception.getClass())) {
            status = Response.Status.FORBIDDEN;
        } else if (exception.getClass() == ResourceRegistryException.class) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        try {
            String entity = ExceptionMapper.marshal((ResourceRegistryException)exception);
            MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
            return Response.status((Response.Status)status).entity((Object)entity).type(mediaType).build();
        }
        catch (Exception e) {
            String entity = exception.getMessage();
            MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
            return Response.status((Response.Status)status).entity((Object)entity).type(mediaType).build();
        }
    }
}

