/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EntityManagement<E extends Entity>
extends ERManagement<E, Vertex> {
    private static Logger logger = LoggerFactory.getLogger(EntityManagement.class);

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
    }

    protected EntityManagement(AccessType accessType, OrientGraph orientGraph) {
        this(accessType);
        this.orientGraph = orientGraph;
    }

    public abstract Vertex reallyCreate() throws EntityAlreadyPresentException, ResourceRegistryException;

    protected Vertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.erType, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.erType);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertexEntity = this.orientGraph.addVertex((Object)("class:" + this.erType));
            try {
                Vertex v;
                if (this.uuid != null && (v = (Vertex)this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.erType, this.uuid.toString());
                    throw this.getSpecificERAlreadyPresentException(error);
                }
            }
            catch (ERNotFoundException e) {
                try {
                    Element el = EntityManagement.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof Vertex ? "Entity" : "Relation");
                    throw this.getSpecificERAvailableInAnotherContextException(error);
                }
                catch (ERNotFoundException eRNotFoundException) {
                }
            }
            catch (ERAvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            Header entityHeader = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)true);
            if (entityHeader != null) {
                ((Vertex)this.element).setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Vertex)((Vertex)this.element), null);
            }
            if (this.accessType.compareTo((Enum)AccessType.RESOURCE) != 0) {
                ERManagement.updateProperties((OClass)this.oClass, (Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.element);
            ((OrientVertex)this.element).save();
            logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)((OrientVertex)this.element), (boolean)true));
            return (Vertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.erType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.erType + " with " + this.jsonNode, e.getCause());
        }
    }

    public boolean reallyAddToContext() throws ContextException, ResourceRegistryException {
        ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.getElement());
        Iterable edges = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            relationManagement.reallyAddToContext();
        }
        return true;
    }

    public boolean reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        ContextUtility.removeFromActualContext((OrientGraph)this.orientGraph, (Element)this.getElement());
        Iterable edges = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            relationManagement.reallyRemoveFromContext();
        }
        return true;
    }

    public static EntityManagement getEntityManagement(OrientGraph orientGraph, Vertex vertex) throws ResourceRegistryException {
        if (orientGraph == null) {
            throw new ResourceRegistryException(OrientGraph.class.getSimpleName() + "instance is null. This is really strage please contact the administrator.");
        }
        if (vertex == null) {
            throw new ResourceRegistryException(Vertex.class.getSimpleName() + "instance is null. This is really strage please contact the administrator.");
        }
        OrientVertexType orientVertexType = null;
        try {
            orientVertexType = ((OrientVertex)vertex).getType();
        }
        catch (Exception e) {
            String error = String.format("Unable to detect type of %s. This is really strage please contact the administrator.", vertex.toString());
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error);
        }
        ResourceManagement entityManagement = null;
        if (orientVertexType.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement(orientGraph);
        } else if (orientVertexType.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement(orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange and should not occur. Please Investigate it.", vertex, "Resource", "Facet");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setElement((Element)vertex);
        return entityManagement;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        Iterable iterable = this.orientGraph.getVerticesOfClass(this.erType, polymorphic);
        for (Vertex vertex : iterable) {
            EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)vertex);
            try {
                JSONObject jsonObject = entityManagement.serializeAsJson();
                jsonArray.put((Object)jsonObject);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. This is really strange and should not occur.", (Object)vertex.toString());
            }
        }
        return jsonArray.toString();
    }
}

