/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.context.SecurityContext;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseIntializator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SecurityContextMapper {
    private static Logger logger = LoggerFactory.getLogger(SecurityContextMapper.class);
    public static final String ADMIN_SECURITY_CONTEXT = "00000000-0000-0000-0000-000000000000";
    public static final UUID ADMIN_SECURITY_CONTEXT_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final String MANAGEMENT_SECURITY_CONTEXT = "ffffffff-ffff-ffff-ffff-ffffffffffff";
    public static final UUID MANAGEMENT_SECURITY_CONTEXT_UUID = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    private static final Map<PermissionMode, Map<UUID, OrientGraphFactory>> securityContextFactories;

    public static OrientGraphFactory getSecurityContextFactory(UUID context, PermissionMode permissionMode) {
        OrientGraphFactory factory = null;
        Map permissionSecurityContextFactories = (Map)securityContextFactories.get(permissionMode);
        factory = (OrientGraphFactory)permissionSecurityContextFactories.get(context);
        if (factory == null) {
            String username = SecurityContextMapper.getSecurityRoleOrUserName((PermissionMode)permissionMode, (SecurityType)SecurityType.USER, (UUID)context);
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            factory = new OrientGraphFactory(DatabaseEnvironment.DB_URI, username, password).setupPool(1, 10);
            factory.setConnectionStrategy(DatabaseIntializator.CONNECTION_STRATEGY_PARAMETER.toString());
            permissionSecurityContextFactories.put(context, factory);
        }
        return factory;
    }

    public static String getSecurityRoleOrUserName(PermissionMode permissionMode, SecurityType securityType, UUID context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        stringBuilder.append("_");
        stringBuilder.append(context.toString());
        return stringBuilder.toString();
    }

    static {
        try {
            boolean created = DatabaseIntializator.initGraphDB();
            logger.trace("Creating factory for {} connecting as {}", (Object)DatabaseEnvironment.DB_URI, (Object)DatabaseEnvironment.CHANGED_ADMIN_USERNAME);
            securityContextFactories = new HashMap();
            OrientGraphFactory factory = new OrientGraphFactory(DatabaseEnvironment.DB_URI, DatabaseEnvironment.CHANGED_ADMIN_USERNAME, DatabaseEnvironment.CHANGED_ADMIN_PASSWORD).setupPool(1, 10);
            factory.setConnectionStrategy(DatabaseIntializator.CONNECTION_STRATEGY_PARAMETER.toString());
            for (PermissionMode p : PermissionMode.values()) {
                OrientGraphFactory f = new OrientGraphFactory(DatabaseEnvironment.DB_URI, DatabaseEnvironment.CHANGED_ADMIN_USERNAME, DatabaseEnvironment.CHANGED_ADMIN_PASSWORD).setupPool(1, 10);
                f.setConnectionStrategy(DatabaseIntializator.CONNECTION_STRATEGY_PARAMETER.toString());
                HashMap<UUID, OrientGraphFactory> map = new HashMap<UUID, OrientGraphFactory>();
                map.put(ADMIN_SECURITY_CONTEXT_UUID, f);
                securityContextFactories.put(p, map);
            }
            if (created) {
                OrientGraph orientGraph = factory.getTx();
                SecurityContext.createSecurityContext((OrientGraph)orientGraph, (UUID)MANAGEMENT_SECURITY_CONTEXT_UUID);
                SecurityContextMapper.getSecurityContextFactory((UUID)MANAGEMENT_SECURITY_CONTEXT_UUID, (PermissionMode)PermissionMode.READER);
                SecurityContextMapper.getSecurityContextFactory((UUID)MANAGEMENT_SECURITY_CONTEXT_UUID, (PermissionMode)PermissionMode.WRITER);
                DatabaseIntializator.createEntitiesAndRelations();
            }
        }
        catch (Exception e) {
            logger.error("Error initializing database connection", (Throwable)e);
            throw new RuntimeException("Error initializing database connection", e);
        }
    }
}

