/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.embedded.PropagationConstraint;
import org.gcube.informationsystem.model.relation.IsParentOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextManagement;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;

public class IsParentOfManagement
extends RelationManagement<IsParentOf, ContextManagement, ContextManagement> {
    public IsParentOfManagement() {
        super(AccessType.IS_PARENT_OF);
    }

    public IsParentOfManagement(OrientGraph orientGraph) throws ResourceRegistryException {
        this();
        this.orientGraph = orientGraph;
        this.getWorkingContext();
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.CONTEXT_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    protected void checkJSON() throws ResourceRegistryException {
        super.checkJSON();
        if (this.jsonNode.has("propagationConstraint")) {
            String addProperty;
            PropagationConstraint.AddConstraint addConstraint;
            String removeProperty;
            PropagationConstraint.RemoveConstraint removeConstraint;
            StringBuilder message = null;
            JsonNode propagationConstraint = this.jsonNode.get("propagationConstraint");
            if (propagationConstraint.has("remove") && (removeConstraint = PropagationConstraint.RemoveConstraint.valueOf((String)(removeProperty = propagationConstraint.get("remove").asText()))) != PropagationConstraint.RemoveConstraint.keep) {
                message = new StringBuilder();
                message.append(PropagationConstraint.RemoveConstraint.class.getSimpleName());
                message.append(" can only be ");
                message.append(PropagationConstraint.RemoveConstraint.keep.name());
            }
            if (propagationConstraint.has("add") && (addConstraint = PropagationConstraint.AddConstraint.valueOf((String)(addProperty = propagationConstraint.get("add").asText()))) != PropagationConstraint.AddConstraint.unpropagate) {
                if (message == null) {
                    message = new StringBuilder();
                } else {
                    message.append(" and ");
                }
                message.append(PropagationConstraint.AddConstraint.class.getSimpleName());
                message.append(" can only be ");
                message.append(PropagationConstraint.AddConstraint.unpropagate.name());
            }
            if (message != null) {
                throw new ResourceRegistryException(message.toString());
            }
        }
    }

    protected IsParentOfNotFoundException getSpecificElementNotFoundException(ERNotFoundException e) {
        return new IsParentOfNotFoundException(e.getMessage(), e.getCause());
    }

    protected RelationAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new RelationAvailableInAnotherContextException(message);
    }

    protected IsParentOfAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new IsParentOfAlreadyPresentException(message);
    }

    public JSONObject serializeAsJson() throws ResourceRegistryException {
        return this.serializeAsJson(false, true);
    }

    public JSONObject serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
        JSONObject relation = this.serializeSelfOnly();
        try {
            Vertex source = ((Edge)this.element).getVertex(Direction.OUT);
            ContextManagement sourceContextManagement = new ContextManagement(this.orientGraph);
            sourceContextManagement.setElement((Element)source);
            if (includeSource) {
                relation.put("source", (Object)sourceContextManagement.serializeSelfOnly());
            }
            Vertex target = ((Edge)this.element).getVertex(Direction.IN);
            ContextManagement targetContextManagement = new ContextManagement(this.orientGraph);
            targetContextManagement.setElement((Element)target);
            if (includeTarget) {
                relation.put("target", (Object)targetContextManagement.serializeSelfOnly());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    public boolean addToContext() throws ERNotFoundException, ContextException {
        throw new UnsupportedOperationException();
    }

    public boolean removeFromContext() throws ERNotFoundException, ContextException {
        throw new UnsupportedOperationException();
    }

    protected ContextManagement newSourceEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.orientGraph);
    }

    protected ContextManagement newTargetEntityManagement() throws ResourceRegistryException {
        return new ContextManagement(this.orientGraph);
    }
}

