/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="er")
public class ERManager {
    private static Logger logger = LoggerFactory.getLogger(ERManager.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";

    @PUT
    @Path(value="facet/{type}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createFacet(@PathParam(value="type") String type, String json) throws FacetAlreadyPresentException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.PUT.name() + " /" + "er" + "/" + "facet" + "/" + type);
        logger.info("Requested to create {} of type {}", (Object)"Facet", (Object)type);
        logger.trace("Requested to create {} of type {} defined by {} ", new Object[]{"Facet", type, json});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setElementType(type);
        facetManagement.setJSON(json);
        String ret = facetManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @POST
    @Path(value="facet/{id}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateFacet(@PathParam(value="id") String uuid, String json) throws FacetNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "facet" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to update {} with id {}", (Object)"Facet", (Object)uuid);
        logger.trace("Requested to update {} with id {} with json {}", new Object[]{"Facet", uuid, json});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        facetManagement.setJSON(json);
        return facetManagement.update();
    }

    @DELETE
    @Path(value="facet/{id}")
    public boolean deleteFacet(@PathParam(value="id") String uuid) throws FacetNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.DELETE.name() + " /" + "er" + "/" + "facet" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to delete {} with id {}", (Object)"Facet", (Object)uuid);
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.delete();
    }

    @PUT
    @Path(value="resource/{type}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createResource(@PathParam(value="type") String type, String json) throws ResourceAlreadyPresentException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.PUT.name() + " /" + "er" + "/" + "resource" + "/" + type);
        logger.info("Requested to create {} of type {}", (Object)"Resource", (Object)type);
        logger.trace("Requested to create {} of type {} with json {}", new Object[]{"Resource", type, json});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setElementType(type);
        resourceManagement.setJSON(json);
        String ret = resourceManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @POST
    @Path(value="resource/{id}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateResource(@PathParam(value="id") String uuid, String json) throws ResourceNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "resource" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to update {} with id {}", (Object)"Resource", (Object)uuid);
        logger.trace("Requested to update {} with id {} with json {}", new Object[]{"Resource", uuid, json});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        resourceManagement.setJSON(json);
        return resourceManagement.update();
    }

    @DELETE
    @Path(value="resource/{id}")
    public boolean deleteResource(@PathParam(value="id") String uuid) throws ResourceNotFoundException, Exception {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.DELETE.name() + " /" + "er" + "/" + "resource" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to delete {} with id {}", (Object)"Resource", (Object)uuid);
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.delete();
    }

    @PUT
    @Path(value="consistsOf/{type}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createConsistsOf(@PathParam(value="type") String type, String json) throws ResourceAlreadyPresentException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.PUT.name() + " /" + "er" + "/" + "consistsOf" + "/" + type);
        logger.info("Requested to create {} of type {}", (Object)"ConsistsOf", (Object)type);
        logger.trace("Requested to create {} of type {} with json {}", new Object[]{"ConsistsOf", type, json});
        ConsistsOfManagement consistsOfManagement = new ConsistsOfManagement();
        consistsOfManagement.setElementType(type);
        consistsOfManagement.setJSON(json);
        String ret = consistsOfManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @DELETE
    @Path(value="consistsOf/{id}")
    public boolean detachFacet(@PathParam(value="id") String consistOfUUID) throws ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.DELETE.name() + " /" + "er" + "/" + "consistsOf" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to delete {} with id {}", (Object)"ConsistsOf", (Object)consistOfUUID);
        ConsistsOfManagement consistsOfManagement = new ConsistsOfManagement();
        consistsOfManagement.setUUID(UUID.fromString(consistOfUUID));
        return consistsOfManagement.delete();
    }

    @PUT
    @Path(value="isRelatedTo/{type}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createIsRelatedTo(@PathParam(value="type") String type, String json) throws ResourceAlreadyPresentException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.PUT.name() + " /" + "er" + "/" + "isRelatedTo" + "/" + type);
        logger.info("Requested to create {} of type {} with json {}", new Object[]{"IsRelatedTo", type, json});
        IsRelatedToManagement isRelatedToManagement = new IsRelatedToManagement();
        isRelatedToManagement.setElementType(type);
        isRelatedToManagement.setJSON(json);
        String ret = isRelatedToManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @DELETE
    @Path(value="isRelatedTo/{id}")
    public boolean detachResource(@PathParam(value="id") String relatedToUUID) throws ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.DELETE.name() + " /" + "er" + "/" + "isRelatedTo" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to delete {} with id {}", (Object)"IsRelatedTo", (Object)relatedToUUID);
        IsRelatedToManagement isRelatedToManagement = new IsRelatedToManagement();
        isRelatedToManagement.setUUID(UUID.fromString(relatedToUUID));
        return isRelatedToManagement.delete();
    }

    @POST
    @Path(value="add/resource/{id}")
    public boolean addResourceToContext(@PathParam(value="id") String uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "add" + "/" + "resource" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to add {} with UUID {} to current {}", new Object[]{"Resource", uuid, "Context"});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.addToContext();
    }

    @POST
    @Path(value="add/facet/{id}")
    public boolean addFacetToContext(@PathParam(value="id") String uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "add" + "/" + "facet" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to add {} with UUID {} to current {}", new Object[]{"Facet", uuid, "Context"});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.addToContext();
    }

    @POST
    @Path(value="remove/resource/{id}")
    public boolean removeResourceFromContext(@PathParam(value="id") String uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "remove" + "/" + "resource" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to remove {} with UUID {} from current {}", new Object[]{"Resource", uuid, "Context"});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.removeFromContext();
    }

    @POST
    @Path(value="remove/facet/{id}")
    public boolean removeFacetFromContext(@PathParam(value="id") String uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.POST.name() + " /" + "er" + "/" + "remove" + "/" + "facet" + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to remove {} with UUID {} from current {}", new Object[]{"Facet", uuid, "Context"});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.removeFromContext();
    }
}

