/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context.security;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    protected static final String DEFAULT_WRITER_ROLE = "writer";
    protected static final String DEFAULT_READER_ROLE = "reader";
    public static final String H = "H";
    protected final boolean hierarchic;
    protected final UUID context;
    protected final Map<Boolean, Map<PermissionMode, OrientGraphFactory>> factoryMap;
    protected SecurityContext parentSecurityContext;
    protected Set<SecurityContext> children;

    protected boolean isHierarchicMode() {
        return this.hierarchic && (Boolean)ContextUtility.getHierarchicMode().get() != false;
    }

    public void setParentSecurityContext(SecurityContext parentSecurityContext) {
        if (this.parentSecurityContext != null) {
            this.parentSecurityContext.getChildren().remove(this);
        }
        this.parentSecurityContext = parentSecurityContext;
        if (parentSecurityContext != null) {
            this.parentSecurityContext.addChild(this);
        }
    }

    public SecurityContext getParentSecurityContext() {
        return this.parentSecurityContext;
    }

    private void addChild(SecurityContext child) {
        this.children.add(child);
    }

    public Set<SecurityContext> getChildren() {
        return this.children;
    }

    protected OrientGraph getAdminOrientGraph() throws ResourceRegistryException {
        return ContextUtility.getAdminSecurityContext().getGraph(PermissionMode.WRITER);
    }

    private Set<SecurityContext> getAllChildren() {
        HashSet<SecurityContext> allChildren = new HashSet<SecurityContext>();
        allChildren.add(this);
        for (SecurityContext securityContext : this.getChildren()) {
            allChildren.addAll(securityContext.getAllChildren());
        }
        return allChildren;
    }

    private Set<SecurityContext> getAllParents() {
        HashSet<SecurityContext> allParents = new HashSet<SecurityContext>();
        for (SecurityContext parent = this.getParentSecurityContext(); parent != null; parent = parent.getParentSecurityContext()) {
            allParents.add(parent);
        }
        return allParents;
    }

    public void changeParentSecurityContext(SecurityContext newParentSecurityContext, OrientGraph orientGraph) throws ResourceRegistryException {
        if (!this.hierarchic) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Cannot change parent ");
            errorMessage.append(SecurityContext.class.getSimpleName());
            errorMessage.append(" to non hierarchic ");
            errorMessage.append(SecurityContext.class.getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            String error = errorMessage.toString();
            logger.error(error);
            throw new RuntimeException(error);
        }
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        Set allChildren = this.getAllChildren();
        Set oldParents = this.getAllParents();
        Set newParents = new HashSet();
        if (newParentSecurityContext != null) {
            newParents = newParentSecurityContext.getAllParents();
        }
        oldParents.removeAll(newParents);
        this.removeChildrenHRolesFromParents(oSecurity, oldParents, allChildren);
        this.setParentSecurityContext(newParentSecurityContext);
        if (newParentSecurityContext != null) {
            for (PermissionMode permissionMode : PermissionMode.values()) {
                for (SecurityContext child : allChildren) {
                    String roleName = child.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, true);
                    ORole role = oSecurity.getRole(roleName);
                    this.getParentSecurityContext().addHierarchicRoleToParent(oSecurity, permissionMode, role);
                }
            }
        }
    }

    protected SecurityContext(UUID context, boolean hierarchic) throws ResourceRegistryException {
        this.context = context;
        this.factoryMap = new HashMap();
        this.hierarchic = hierarchic;
        this.children = new HashSet();
    }

    public SecurityContext(UUID context) throws ResourceRegistryException {
        this(context, true);
    }

    private synchronized OrientGraphFactory getFactory(PermissionMode permissionMode, boolean recreate) {
        OrientGraphFactory factory = null;
        Boolean h = this.isHierarchicMode();
        HashMap<PermissionMode, OrientGraphFactory> factories = (HashMap<PermissionMode, OrientGraphFactory>)this.factoryMap.get(h);
        if (factories == null) {
            factories = new HashMap<PermissionMode, OrientGraphFactory>();
        } else if (recreate) {
            factories.remove(permissionMode);
        }
        factory = (OrientGraphFactory)factories.get(permissionMode);
        if (factory == null) {
            String username = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, h.booleanValue());
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            factory = new OrientGraphFactory(DatabaseEnvironment.DB_URI, username, password).setupPool(1, 10);
            factory.setConnectionStrategy(DatabaseEnvironment.CONNECTION_STRATEGY_PARAMETER.toString());
            factories.put(permissionMode, factory);
        }
        return factory;
    }

    public UUID getUUID() {
        return this.context;
    }

    public String getSecurityRoleOrUserName(PermissionMode permissionMode, SecurityType securityType, boolean hierarchic) {
        StringBuilder stringBuilder = new StringBuilder();
        if (hierarchic) {
            stringBuilder.append("H");
        }
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        stringBuilder.append("_");
        stringBuilder.append(this.context.toString());
        return stringBuilder.toString();
    }

    private OSecurity getOSecurity(OrientGraph orientGraph) {
        ODatabaseDocumentTx oDatabaseDocumentTx = orientGraph.getRawGraph();
        return oDatabaseDocumentTx.getMetadata().getSecurity();
    }

    public void addElement(Element element) throws ResourceRegistryException {
        this.addElement(element, this.getAdminOrientGraph());
    }

    protected void allow(OSecurity oSecurity, ODocument oDocument, boolean hierarchic) {
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void addElement(Element element, OrientGraph orientGraph) {
        OrientElement orientElement = (OrientElement)element;
        ODocument oDocument = orientElement.getRecord();
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        this.allow(oSecurity, oDocument, false);
        if (this.hierarchic) {
            this.allow(oSecurity, oDocument, true);
        }
        oDocument.save();
        orientElement.save();
    }

    public void removeElement(Element element) throws ResourceRegistryException {
        this.removeElement(element, this.getAdminOrientGraph());
    }

    protected void deny(OSecurity oSecurity, ODocument oDocument, boolean hierarchic) {
        String writerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER, hierarchic);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_ALL, writerUserName);
        String readerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER, hierarchic);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_READ, readerUserName);
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE, hierarchic);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE, hierarchic);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void removeElement(Element element, OrientGraph orientGraph) {
        OrientElement orientElement = (OrientElement)element;
        ODocument oDocument = orientElement.getRecord();
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        this.deny(oSecurity, oDocument, false);
        if (this.hierarchic) {
            this.deny(oSecurity, oDocument, true);
        }
        oDocument.save();
        orientElement.save();
    }

    protected boolean allowed(ORole role, ODocument oDocument) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        1 callable = new /* Unavailable Anonymous Inner Class!! */;
        Future result = executor.submit(callable);
        try {
            return (Boolean)result.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void create() throws ResourceRegistryException {
        OrientGraph orientGraph = this.getAdminOrientGraph();
        this.create(orientGraph);
        orientGraph.commit();
        orientGraph.shutdown();
    }

    protected ORole addExtraRules(ORole role, PermissionMode permissionMode) {
        return role;
    }

    protected ORole getSuperRole(OSecurity oSecurity, PermissionMode permissionMode) {
        String superRoleName = permissionMode.name().toLowerCase();
        return oSecurity.getRole(superRoleName);
    }

    protected void addHierarchicRoleToParent(OSecurity oSecurity, PermissionMode permissionMode, ORole role) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        user.addRole((OSecurityRole)role);
        user.save();
        if (this.getParentSecurityContext() != null) {
            this.getParentSecurityContext().addHierarchicRoleToParent(oSecurity, permissionMode, role);
        }
    }

    protected void createRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray = this.hierarchic ? new boolean[]{false, true} : new boolean[]{false};
        for (boolean hierarchic : booleanArray) {
            for (PermissionMode permissionMode : PermissionMode.values()) {
                ORole superRole = this.getSuperRole(oSecurity, permissionMode);
                String roleName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, hierarchic);
                ORole role = oSecurity.createRole(roleName, superRole, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
                this.addExtraRules(role, permissionMode);
                role.save();
                logger.trace("{} created", (Object)role);
                if (hierarchic && this.getParentSecurityContext() != null) {
                    this.getParentSecurityContext().addHierarchicRoleToParent(oSecurity, permissionMode, role);
                }
                String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, hierarchic);
                OUser user = oSecurity.createUser(userName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode), new ORole[]{role});
                user.save();
                logger.trace("{} created", (Object)user);
            }
        }
    }

    public void create(OrientGraph orientGraph) {
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        this.createRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully created", (Object)this.context.toString());
    }

    private void drop(OSecurity oSecurity, String name, SecurityType securityType) {
        boolean dropped = false;
        switch (2.$SwitchMap$org$gcube$informationsystem$resourceregistry$context$security$SecurityContext$SecurityType[securityType.ordinal()]) {
            case 1: {
                dropped = oSecurity.dropRole(name);
                break;
            }
            case 2: {
                dropped = oSecurity.dropUser(name);
                break;
            }
        }
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)name);
        } else {
            logger.error("{} was not dropped successfully", (Object)name);
        }
    }

    public void delete() throws ResourceRegistryException {
        OrientGraph orientGraph = this.getAdminOrientGraph();
        this.delete(orientGraph);
        orientGraph.commit();
        orientGraph.shutdown();
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity) {
        Set parents = this.getAllParents();
        Set allChildren = this.getAllChildren();
        this.removeChildrenHRolesFromParents(oSecurity, parents, allChildren);
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity, Set<SecurityContext> parents, Set<SecurityContext> children) {
        for (SecurityContext parent : parents) {
            parent.removeChildrenHRolesFromMyHUsers(oSecurity, children);
        }
    }

    protected void removeChildrenHRolesFromMyHUsers(OSecurity oSecurity, Set<SecurityContext> children) {
        for (PermissionMode permissionMode : PermissionMode.values()) {
            String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
            OUser user = oSecurity.getUser(userName);
            for (SecurityContext child : children) {
                String roleName = child.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE, true);
                logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
                boolean removed = user.removeRole(roleName);
                logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
            }
            user.save();
        }
    }

    protected void removeHierarchicRoleFromMyHUser(OSecurity oSecurity, PermissionMode permissionMode, String roleName) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
        boolean removed = user.removeRole(roleName);
        logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
        user.save();
    }

    protected void deleteRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray = this.hierarchic ? new boolean[]{false, true} : new boolean[]{false};
        for (boolean hierarchic : booleanArray) {
            if (hierarchic) {
                this.removeChildrenHRolesFromParents(oSecurity);
            }
            for (PermissionMode permissionMode : PermissionMode.values()) {
                for (SecurityType securityType : SecurityType.values()) {
                    String name = this.getSecurityRoleOrUserName(permissionMode, securityType, hierarchic);
                    this.drop(oSecurity, name, securityType);
                }
            }
        }
    }

    public void delete(OrientGraph orientGraph) {
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        logger.trace("Going to remove Security Context (roles and users) with UUID {}", (Object)this.context.toString());
        this.deleteRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully removed", (Object)this.context.toString());
    }

    public OrientGraph getGraph(PermissionMode permissionMode) {
        OrientGraphFactory factory = this.getFactory(permissionMode, false);
        OrientGraph orientGraph = factory.getTx();
        if (orientGraph.isClosed()) {
            factory.close();
            factory = this.getFactory(permissionMode, true);
            orientGraph = factory.getTx();
        }
        return orientGraph;
    }

    public OrientGraphNoTx getGraphNoTx(PermissionMode permissionMode) {
        OrientGraphFactory factory = this.getFactory(permissionMode, false);
        OrientGraphNoTx orientGraphNoTx = factory.getNoTx();
        if (orientGraphNoTx.isClosed()) {
            factory.close();
            factory = this.getFactory(permissionMode, true);
            orientGraphNoTx = factory.getNoTx();
        }
        return orientGraphNoTx;
    }

    public ODatabaseDocumentTx getDatabaseDocumentTx(PermissionMode permissionMode) {
        OrientGraphFactory factory = this.getFactory(permissionMode, false);
        ODatabaseDocumentTx databaseDocumentTx = factory.getDatabase();
        if (databaseDocumentTx.isClosed()) {
            factory.close();
            factory = this.getFactory(permissionMode, true);
            databaseDocumentTx = factory.getDatabase();
        }
        return databaseDocumentTx;
    }

    public String toString() {
        return String.format("%s %s", "Context", this.getUUID().toString());
    }
}

