/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import org.gcube.informationsystem.model.impl.utils.discovery.SchemaAction;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.embedded.Embedded;
import org.gcube.informationsystem.model.reference.entity.Entity;
import org.gcube.informationsystem.model.reference.entity.Facet;
import org.gcube.informationsystem.model.reference.entity.Resource;
import org.gcube.informationsystem.model.reference.relation.ConsistsOf;
import org.gcube.informationsystem.model.reference.relation.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaActionImpl
implements SchemaAction {
    private static Logger logger = LoggerFactory.getLogger(SchemaActionImpl.class);
    protected SchemaManagement schemaManagement = new SchemaManagementImpl();

    public <R extends Relation<? extends Entity, ? extends Entity>> void manageRelationClass(Class<R> r) throws Exception {
        try {
            ((SchemaManagementImpl)this.schemaManagement).setTypeName(TypeBinder.getType(r));
            String json = TypeBinder.serializeType(r);
            logger.trace(json);
            if (ConsistsOf.class.isAssignableFrom(r)) {
                this.schemaManagement.create(json, AccessType.CONSISTS_OF);
            } else if (IsRelatedTo.class.isAssignableFrom(r)) {
                this.schemaManagement.create(json, AccessType.IS_RELATED_TO);
            } else {
                this.schemaManagement.create(json, AccessType.RELATION);
            }
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeBinder.getType(r));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Relation", r.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends Entity> void manageEntityClass(Class<E> e) throws Exception {
        try {
            ((SchemaManagementImpl)this.schemaManagement).setTypeName(TypeBinder.getType(e));
            String json = TypeBinder.serializeType(e);
            logger.trace(json);
            if (Facet.class.isAssignableFrom(e)) {
                this.schemaManagement.create(json, AccessType.FACET);
            } else if (Resource.class.isAssignableFrom(e)) {
                this.schemaManagement.create(json, AccessType.RESOURCE);
            } else {
                this.schemaManagement.create(json, AccessType.ENTITY);
            }
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeBinder.getType(e));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Entity", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends Embedded> void manageEmbeddedClass(Class<E> e) throws Exception {
        try {
            ((SchemaManagementImpl)this.schemaManagement).setTypeName(TypeBinder.getType(e));
            String json = TypeBinder.serializeType(e);
            logger.trace(json);
            this.schemaManagement.create(json, AccessType.EMBEDDED);
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeBinder.getType(e));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} type {} : {}", new Object[]{"Embedded", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }
}

