/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.ArrayList;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.context.ContextManagement;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.rest.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="contexts")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod) {
        this.setCalledMethod(httpMethod, null);
    }

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod, String uuid) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("contexts");
        if (uuid != null) {
            list.add(uuid);
        }
        Access.setCalledMethod((HTTPCall.HTTPMETHOD)httpMethod, list, null);
    }

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String all() throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to read all {}s", (Object)"Context");
        this.setCalledMethod(HTTPCall.HTTPMETHOD.GET);
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentSecurityContext().getUUID().toString();
        }
        logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.GET, uuid);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.read();
    }

    @PUT
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateCreate(@PathParam(value="CONTEXT_UUID") String uuid, String json) throws ResourceRegistryException {
        logger.info("Requested to update/create {} with json {} ", (Object)"Context", (Object)json);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.PUT, uuid);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.setJSON(json);
        return contextManagement.createOrUpdate();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{CONTEXT_UUID}")
    public boolean delete(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.DELETE, uuid);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.delete();
    }
}

