/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.rest.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="instances")
public class InstancesManager {
    private static Logger logger = LoggerFactory.getLogger(InstancesManager.class);

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod, String type, Map<String, String> map) {
        this.setCalledMethod(httpMethod, type, false, map);
    }

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod, String type, boolean uuid) {
        this.setCalledMethod(httpMethod, type, uuid, null);
    }

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod, String type, boolean uuid, Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("instances");
        list.add(type);
        if (uuid) {
            list.add("{UUID}");
        }
        Access.setCalledMethod((HTTPCall.HTTPMETHOD)httpMethod, list, map);
    }

    @GET
    @Path(value="/{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String readAll(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("polymorphic", polymorphic.toString());
        this.setCalledMethod(HTTPCall.HTTPMETHOD.GET, type, map);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response exists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.HEAD, type, true);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.GET, type, true);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read();
    }

    @PUT
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateOrCreate(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid, String json) throws ResourceRegistryException {
        logger.info("Requested to update/create {} with id {}", (Object)type, (Object)uuid);
        logger.trace("Requested to update/create {} with id {} with json {}", new Object[]{type, uuid, json});
        this.setCalledMethod(HTTPCall.HTTPMETHOD.PUT, type, true);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        erManagement.setElementType(type);
        erManagement.setJSON(json);
        return erManagement.createOrUpdate();
    }

    @DELETE
    @Path(value="/{TYPE_NAME}/{UUID}")
    public boolean delete(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws ResourceRegistryException {
        logger.info("Requested to delete {} with id {}", (Object)type, (Object)uuid);
        this.setCalledMethod(HTTPCall.HTTPMETHOD.DELETE, type, true);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.delete();
    }
}

