/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.query.Query;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static Logger logger = LoggerFactory.getLogger(QueryImpl.class);

    public String query(String query, Integer limit, String fetchPlan, boolean raw) throws InvalidQueryException {
        if (limit == null) {
            limit = 20;
        }
        limit = limit <= 0 ? -1 : limit;
        OrientGraph orientGraph = null;
        try {
            SecurityContext securityContext = ContextUtility.getCurrentSecurityContext();
            orientGraph = securityContext.getGraph(SecurityContext.PermissionMode.READER);
            orientGraph.setAutoStartTx(false);
            orientGraph.begin();
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(query, limit.intValue());
            osqlSynchQuery.setFetchPlan(fetchPlan);
            osqlSynchQuery.setCacheableResult(true);
            logger.debug("Going to execute query : \"{}\", fetchPlan : \"{}\", limit : {}", new Object[]{osqlSynchQuery.getText(), osqlSynchQuery.getFetchPlan(), osqlSynchQuery.getLimit()});
            Iterable elements = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = objectMapper.createArrayNode();
            for (Element element : elements) {
                try {
                    JsonNode jsonNode = null;
                    if (raw) {
                        jsonNode = Utility.toJsonNode((Element)element, (boolean)false);
                    } else {
                        ERManagement erManagement = ERManagementUtility.getERManagement((SecurityContext)securityContext, (OrientGraph)orientGraph, (Element)element);
                        jsonNode = erManagement.serializeAsJson();
                    }
                    arrayNode.add(jsonNode);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)element.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                }
            }
            String string = objectMapper.writeValueAsString((Object)arrayNode);
            return string;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String gremlinQuery(String query) throws InvalidQueryException {
        throw new UnsupportedOperationException();
    }
}

