package org.gcube.informationsystem.resourceregistry.types.relations;

import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.types.entities.FacetTypeDefinitionManagement;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

public class ConsistsOfTypeDefinitionManagement
		extends RelationTypeDefinitionManagement<FacetTypeDefinitionManagement,FacetType> {
	
	public ConsistsOfTypeDefinitionManagement() {
		super(FacetType.class);
		this.elementType = ConsistsOfType.NAME;
	}
	
	public ConsistsOfTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument)
			throws ResourceRegistryException {
		super(securityContext, oDatabaseDocument, FacetType.class);
		this.elementType = ConsistsOfType.NAME;
	}
	
	@Override
	protected FacetTypeDefinitionManagement newTargetEntityManagement() throws ResourceRegistryException {
		return new FacetTypeDefinitionManagement(getWorkingContext(), oDatabaseDocument);
	}
	
}