package org.gcube.informationsystem.resourceregistry.contexts.relations;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isparentof.IsParentOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OVertex;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsParentOfManagement extends RelationElementManagement<ContextManagement,ContextManagement> {
	
	public IsParentOfManagement() {
		super(AccessType.IS_PARENT_OF, Context.class, Context.class);
	}
	
	public IsParentOfManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
		this();
		this.oDatabaseDocument = oDatabaseDocument;
		getWorkingContext();
	}
	
	@Override
	protected SecurityContext getWorkingContext() throws ResourceRegistryException {
		if(workingContext == null) {
			workingContext = ContextUtility.getInstance()
					.getSecurityContextByUUID(DatabaseEnvironment.CONTEXT_SECURITY_CONTEXT_UUID);
		}
		return workingContext;
	}
	
	@Override
	protected IsParentOfNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
		return new IsParentOfNotFoundException(e.getMessage(), e.getCause());
	}
	
	@Override
	protected IsParentOfAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
		return new IsParentOfAlreadyPresentException(message);
	}
	
	@Override
	public JsonNode serializeAsJson() throws ResourceRegistryException {
		return serializeAsJson(false, true);
	}
	
	public JsonNode serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
		JsonNode relation = serializeSelfOnly();
		
		try {
			OVertex source = element.getVertex(ODirection.OUT);
			ContextManagement sourceContextManagement = new ContextManagement(oDatabaseDocument);
			sourceContextManagement.setElement(source);
			if(includeSource) {
				((ObjectNode)relation).replace(Relation.SOURCE_PROPERTY, sourceContextManagement.serializeSelfOnly());
			}
			
			OVertex target = element.getVertex(ODirection.IN);
			ContextManagement targetContextManagement = new ContextManagement(oDatabaseDocument);
			targetContextManagement.setElement(target);
			if(includeTarget) {
				((ObjectNode)relation).replace(Relation.TARGET_PROPERTY, targetContextManagement.serializeSelfOnly());
			}
			
		} catch(ResourceRegistryException e) {
			logger.error("Unable to correctly serialize {}. {}", element, Utility.SHOULD_NOT_OCCUR_ERROR_MESSAGE, e);
			throw e;
		} catch(Exception e) {
			logger.error("Unable to correctly serialize {}. {}", element, Utility.SHOULD_NOT_OCCUR_ERROR_MESSAGE, e);
			throw new ResourceRegistryException(e);
		}
		
		return relation;
	}
	
	@Override
	protected ContextManagement newSourceEntityManagement() throws ResourceRegistryException {
		return new ContextManagement(oDatabaseDocument);
	}
	
	@Override
	protected ContextManagement newTargetEntityManagement() throws ResourceRegistryException {
		return new ContextManagement(oDatabaseDocument);
	}

	@Override
	protected boolean reallyAddToContext(SecurityContext targetSecurityContext)
			throws ContextException, ResourceRegistryException {
		throw new UnsupportedOperationException();
	}

	@Override
	protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext)
			throws ContextException, ResourceRegistryException {
		throw new UnsupportedOperationException();
	}

	@Override
	protected AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
		throw new UnsupportedOperationException();
	}

	@Override
	public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
		throw new UnsupportedOperationException();
	}
	
}
