package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.AddConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.RemoveConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.consistsOf.ConsistsOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.consistsOf.ConsistsOfAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.consistsOf.ConsistsOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ConsistsOfManagement extends RelationManagement<FacetManagement> {
	
	public static final PropagationConstraint DEFAULT_CONSISTS_OF_PC;

	static {
		DEFAULT_CONSISTS_OF_PC = new PropagationConstraintImpl();
		DEFAULT_CONSISTS_OF_PC.setRemoveConstraint(RemoveConstraint.cascadeWhenOrphan);
		DEFAULT_CONSISTS_OF_PC.setAddConstraint(AddConstraint.propagate);
	}
	
	public ConsistsOfManagement() {
		super(AccessType.CONSISTS_OF, Facet.class, DEFAULT_CONSISTS_OF_PC);
	}
	
	public ConsistsOfManagement(SecurityContext workingContext, ODatabaseDocument orientGraph) {
		super(AccessType.CONSISTS_OF, Facet.class, workingContext, orientGraph, DEFAULT_CONSISTS_OF_PC);
	}
	
	@Override
	protected ConsistsOfNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
		return new ConsistsOfNotFoundException(e.getMessage(), e.getCause());
	}
	
	@Override
	protected ConsistsOfAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(
			String message) {
		return new ConsistsOfAvailableInAnotherContextException(message);
	}
	
	@Override
	protected ConsistsOfAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
		return new ConsistsOfAlreadyPresentException(message);
	}
	
	@Override
	protected FacetManagement newTargetEntityManagement() throws ResourceRegistryException {
		return new FacetManagement(getWorkingContext(), oDatabaseDocument);
	}
	
}
