package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OVertex;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class FacetManagement extends EntityManagement<Facet> {
	
	public FacetManagement() {
		super(AccessType.FACET);
	}
	
	public FacetManagement(SecurityContext workingContext, ODatabaseDocument orientGraph) {
		super(AccessType.FACET, workingContext, orientGraph);
	}
	
	@Override
	protected FacetNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
		return new FacetNotFoundException(e.getMessage(), e.getCause());
	}
	
	@Override
	protected FacetAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
		return new FacetAvailableInAnotherContextException(message);
	}
	
	@Override
	protected FacetAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
		return new FacetAlreadyPresentException(message);
	}
	
	@Override
	public String serialize() throws ResourceRegistryException {
		return serializeSelfOnly().toString();
	}
	
	@Override
	public JsonNode serializeAsJson() throws ResourceRegistryException {
		return serializeSelfOnly();
	}
	
	@Override
	protected OVertex reallyCreate() throws FacetAlreadyPresentException, ResourceRegistryException {
		return createVertex();
	}
	
	@Override
	protected OVertex reallyUpdate() throws FacetNotFoundException, ResourceRegistryException {
		OVertex facet = getElement();
		facet = (OVertex) ElementManagement.updateProperties(oClass, facet, jsonNode, ignoreKeys, ignoreStartWithKeys);
		return facet;
	}
	
	@Override
	protected boolean reallyDelete() throws FacetNotFoundException, ResourceRegistryException {
		getElement().delete();
		return true;
	}
	
}
