package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.AddConstraint;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint.RemoveConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isrelatedto.IsRelatedToAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isrelatedto.IsRelatedToAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.isrelatedto.IsRelatedToNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsRelatedToManagement extends RelationManagement<ResourceManagement> {
	
	public static final PropagationConstraint DEFAULT_IS_RELATED_TO_PC;

	static {
		DEFAULT_IS_RELATED_TO_PC = new PropagationConstraintImpl();
		DEFAULT_IS_RELATED_TO_PC.setRemoveConstraint(RemoveConstraint.keep);
		DEFAULT_IS_RELATED_TO_PC.setAddConstraint(AddConstraint.unpropagate);
	}
	
	public IsRelatedToManagement() {
		super(AccessType.IS_RELATED_TO,  Resource.class, DEFAULT_IS_RELATED_TO_PC);
	}
	
	public IsRelatedToManagement(SecurityContext workingContext, ODatabaseDocument orientGraph) {
		super(AccessType.IS_RELATED_TO, Resource.class, workingContext, orientGraph, DEFAULT_IS_RELATED_TO_PC);
	}
	
	@Override
	protected IsRelatedToNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
		return new IsRelatedToNotFoundException(e.getMessage(), e.getCause());
	}
	
	@Override
	protected IsRelatedToAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(
			String message) {
		return new IsRelatedToAvailableInAnotherContextException(message);
	}
	
	@Override
	protected IsRelatedToAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
		return new IsRelatedToAlreadyPresentException(message);
	}
	
	@Override
	protected ResourceManagement newTargetEntityManagement() throws ResourceRegistryException {
		return new ResourceManagement(getWorkingContext(), oDatabaseDocument);
	}
	
}
