package org.gcube.informationsystem.resourceregistry.utils;

import java.security.Key;

import org.gcube.informationsystem.model.impl.properties.EncryptedImpl;
import org.gcube.informationsystem.model.reference.properties.Encrypted;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;

import com.orientechnologies.orient.core.record.impl.ODocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class EncryptedOrient extends ODocument implements org.gcube.informationsystem.model.reference.properties.Encrypted {
	
	protected String decryptedValue;
	protected String dbEncryptedValue;
	protected String contextEncryptedValue;
	
	public EncryptedOrient() {
		super(Encrypted.NAME);
	}
	
	protected EncryptedOrient(String iClassName) {
		super(iClassName);
	}

	@Override
	public String getEncryptedValue() {
		return this.field(Encrypted.VALUE);
	}

	@Override
	public void setEncryptedValue(String encryptedValue) {
		this.field(Encrypted.VALUE, encryptedValue);
	}
	
	@Override
	public String toJSON(String iFormat) {
		return super.toJSON(iFormat);
	}

	
	public String getDecryptedValue() {
		return decryptedValue;
	}

	public String getDbEncryptedValue() {
		return dbEncryptedValue;
	}

	public String getContextEncryptedValue() {
		return contextEncryptedValue;
	}
	
	public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
		this.decryptedValue = decryptedValue;
		
		// Encrypting with DB Key
		Key databaseKey = DatabaseEnvironment.getDatabaseKey();
		this.dbEncryptedValue = EncryptedImpl.encrypt(decryptedValue, databaseKey);
		
		// Encrypting with Context Key (default key)
		this.contextEncryptedValue = EncryptedImpl.encrypt(decryptedValue);
		
		
		if(setEncryptedForContext) {
			setEncryptedValue(contextEncryptedValue);
		}else {
			setEncryptedValue(dbEncryptedValue);
		}
		
	}
}
