/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;

public class FacetManagement
extends EntityManagement<Facet> {
    public FacetManagement() {
        super(AccessType.FACET);
    }

    public FacetManagement(SecurityContext workingContext, ODatabaseDocument orientGraph) {
        super(AccessType.FACET, workingContext, orientGraph);
    }

    protected FacetNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new FacetNotFoundException(e.getMessage(), e.getCause());
    }

    protected FacetAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new FacetAvailableInAnotherContextException(message);
    }

    protected FacetAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new FacetAlreadyPresentException(message);
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeSelfOnly().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeSelfOnly();
    }

    protected OVertex reallyCreate() throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.createVertex();
    }

    protected OVertex reallyUpdate() throws FacetNotFoundException, ResourceRegistryException {
        OVertex facet = (OVertex)this.getElement();
        facet = (OVertex)ElementManagement.updateProperties((OClass)this.oClass, (OElement)facet, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return facet;
    }

    protected boolean reallyDelete() throws FacetNotFoundException, ResourceRegistryException {
        ((OVertex)this.getElement()).delete();
        return true;
    }
}

